/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import java.util.ArrayList;
import java.util.List;



import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.PredicateUtils;


public class DynaContainer extends DynaComponent implements Container {

	private static final long serialVersionUID = -2266168287249156706L;

	public DynaContainer() {
		super();
	}
	
	public DynaContainer(DynaClass dynaClass) {
		super(dynaClass);
	}

	public List getComponents() {
		List result = new ArrayList();
		CollectionUtils.select(getRawChildren(), PredicateUtils
				.instanceofPredicate(Component.class), result);
		return result;
	}

}
