/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveNatureAction extends Action implements IObjectActionDelegate {
	/** ワークベンチのルートウィンドウ */
	private Shell shell;

	/** ワークベンチ上で選択された項目 (単一の IProject を含む) */
	private ISelection selection;

	/*
	 * (non-javadoc)
	 * 
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction,
	 *      org.eclipse.ui.IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.shell = targetPart.getSite().getShell();
	}

	/*
	 * (non-javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.selection = selection;
	}

	/*
	 * (non-javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		ProgressMonitorDialog dialog;
		try {
			/* ダイアログで進捗モニタを表示 */
			dialog = new ProgressMonitorDialog(shell);
			dialog.setCancelable(true);
			dialog.run(true, true, new IRunnableWithProgress() {
				public void run(final IProgressMonitor monitor)
						throws InvocationTargetException {
					try {
						IProject project = getSelectedProject();
						MaskatNature.removeNature(project, monitor);
					} catch (Exception e) {
						throw new InvocationTargetException(e);
					} finally {
						monitor.done();
					}
				}
			});
		} catch (InvocationTargetException e) {
			Object[] args = new Object[] { e.getTargetException().getMessage() };
			MessageDialog.openError(shell,
					Messages.getString("ui.dialog.addNature"),
					Messages.format("ui.dialog.error", args));
		} catch (InterruptedException e) {
			// キャンセルされた場合
		}
	}

	/**
	 * 選択されている Java 要素を取得します。
	 * 
	 * プラグイン・マニフェストにより、このメソッドの呼び出し結果には 単一の
	 * IProject が返却されることが保障されます。
	 * 
	 * @return 選択されている IProject
	 */
	private IProject getSelectedProject() {
		if (selection != null) {
			if (selection instanceof IStructuredSelection) {
				IStructuredSelection structured = (IStructuredSelection) selection;
				return (IProject) structured.getFirstElement();
			}
		}
		return null;
	}

}

