/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditor;
import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditorActionContributor;
import jp.sf.maskat.ui.editors.xml.MaskatXMLEditor;

import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;


public class MaskatEditorActionBarContributor extends MultiPageEditorActionBarContributor {

	private IEditorPart activeEditorPart;

	private Map contributors;

	public MaskatEditorActionBarContributor() {
		super();
		contributors = new HashMap();
		contributors.put(LayoutGraphicalEditor.class,
				new LayoutGraphicalEditorActionContributor());
		contributors.put(MaskatXMLEditor.class, new TextEditorActionContributor());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorActionBarContributor#init(org.eclipse.ui.IActionBars,
	 *      org.eclipse.ui.IWorkbenchPage)
	 */
	public void init(IActionBars bars, IWorkbenchPage page) {
		super.init(bars, page);

		Iterator iter = contributors.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			((EditorActionBarContributor) entry.getValue()).init(bars, page);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.part.MultiPageEditorActionBarContributor#setActivePage(org.eclipse.ui.IEditorPart)
	 */
	public void setActivePage(IEditorPart part) {
		if (activeEditorPart == part) {
			return;
		}
		activeEditorPart = part;

		IActionBars bars = getActionBars();
		if (bars != null) {
			bars.clearGlobalActionHandlers();
		}

		EditorActionBarContributor contributor = (EditorActionBarContributor) contributors
				.get(part.getClass());
		if (contributor != null) {
			contributor.setActiveEditor(part);
		}
		bars.updateActionBars();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.part.EditorActionBarContributor#dispose()
	 */
	public void dispose() {
		Iterator iter = contributors.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry) iter.next();
			((EditorActionBarContributor) entry.getValue()).dispose();
		}
		super.dispose();
	}

}
