/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.event.Component;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutDef;

import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;


/**
 * The state of layout and event definition. MaskatDef and IEventDefSource's
 * state.
 */
public class MaskatResources {

	private LayoutDef layoutDef = null;

	private EventDef eventDef;

	private IFile layoutXMLFile;

	private IFile eventXMLFile;

	MaskatResources(IFile layoutXMLFile) {
		this.layoutXMLFile = layoutXMLFile;

		// look for link.xml in the same directory as layoutFile.
		IContainer folder = layoutXMLFile.getParent();
		String eventXMLFileName = layoutXMLFile.getLocation().removeFileExtension()
				.lastSegment()
				+ "_e.xml";
		this.eventXMLFile = folder.getFile(new Path(eventXMLFileName));
	}

	public IFile getLayoutXMLFile() {
		return layoutXMLFile;
	}

	public IFile getEventXMLFile() {
		return eventXMLFile;
	}
	
	Layout getLayout() {
		Layout[] layouts = layoutDef.getLayouts();
		return layouts.length > 0 ? layouts[0] : null;
	}

	public void load() throws Exception {
		loadLayout();
		loadEvent();
		connect();
	}
	
	void connect() {
		layoutDef.setEventDef(eventDef);
	}

	void loadLayout() throws Exception {
		InputStream in = null;
		try {
			if (layoutXMLFile.exists()) {
				// contentsからデータを読み込む
				in = layoutXMLFile.getContents();
//				layoutDef = LayoutDefParser.parse(in);
				layoutDef = MaskatBeanIO.readLayoutDef(in);
//				if (layoutDef != null) {
//					Layout[] layouts = layoutDef.getLayouts();
//					for (int i = 0; i < layouts.length; i++) {
//						layouts[i].
//					}
//					Iterator it = layoutDef.getTypedChildren(Layout.class);
//					while (it.hasNext()) {
//						((Layout) it.next()).unpackRadioGroup();
//					}
//				}
			}
		} finally {
			IOUtils.closeQuietly(in);
		}
	}

	void loadEvent() throws Exception {
		// XXX temporarily, assume that files is not empty or null
		eventDef = new EventDef();
		InputStream in = null;
		try {
			eventXMLFile.refreshLocal(IResource.DEPTH_ONE, null);
			if (eventXMLFile.exists()) {
				in = eventXMLFile.getContents();
//				eventDef = EventDefParser.parse(in);
				eventDef = MaskatBeanIO.readEventDef(in);
			}
		} finally {
			IOUtils.closeQuietly(in);
		}
	}

	public void save() throws Exception {
		writeLayout();
		writeEvent();
	}
	
	private void writeLayout() throws Exception {
		// XXX パフォーマンス
/*		Iterator it = layoutDef.getTypedChildren(Layout.class);
		while (it.hasNext()) {
			((Layout) it.next()).packRadioGroup();
		}*/
		//why use clone()?, clone() will cause the propertychange.  
		String output = MaskatBeanIO.writeLayoutDef((LayoutDef)layoutDef/*.clone()*/);

//		byte[] bytes = writer.toString().getBytes("UTF-8");
		byte[] bytes = output.getBytes("UTF-8");
		layoutXMLFile.setContents(new ByteArrayInputStream(bytes), false, false, null);
	}

	private void writeEvent() throws Exception {
		if (eventDef == null) {
			return;
		}

		//use betwix's suppress to do this.
//		MaskatResources.clearDisabledDefElement(eventDef);
//		MaskatResources.clearBlankComponent(eventDef);

//		eventDef.shrinkEvent();

		MaskatResources.marshallObj(eventDef, eventXMLFile, null);

		// event is shrinked so expand them
		eventDef.prepareEvent();
	}

	/**
	 * イベントのないコンポーネントは出力しない
	 * 
	 * @param layout
	 */
	public static void clearBlankComponent(EventDef eventDef) {
		List compsToDel = new ArrayList();
		Component[] components = eventDef.getAllComponents();
		for (int i = 0; i < components.length; i++) {
			if (!components[i].hasEvents()) {
				compsToDel.add(components[i]);
			}			
		}
		for (int i = 0; i < compsToDel.size(); i++) {
			eventDef.removeChild(compsToDel.get(i));
		}
	}

	/**
	 * enable=falseのevent,param,resultは出力しないために、ここでLayoutオブジェクトからそういったイベントを削除する
	 * 
	 * @param layout
	 */
	public static void clearDisabledDefElement(EventDef layout) {
		Component[] components = layout.getAllComponents();
		for (int i = 0; i < components.length; i++) {
			if (!components[i].hasEvents()) {
				Event[] events = components[i].getAllEvents();
				for (int j = 0; j < events.length; j++) {
					if (events[j].isEnable()) {
						components[i].removeChild(events[j]);
					} else if (!events[j].getParam().isEnable()) {
						events[j].removeChild(events[j].getParam());
					} else if (!events[j].getResult().isEnable()) {
						events[j].removeChild(events[j].getResult());
					}
				}
			}
		}
/*		for (Iterator it = layout.getAllComponents(); it != null && it.hasNext();) {
			Component comp = (Component) it.next();
			if (comp.hasEvents()) {
				for (Iterator it2 = comp.getAllEvents(); it2 != null && it2.hasNext();) {
					Event event = (Event) it2.next();
					if (!event.isEnable()) {
						it2.remove();
					} else {
						if (!event.getParam().isEnable()) {
							event.removeAllByType(Param.class);
						}
						if (!event.getResult().isEnable()) {
							event.removeAllByType(Result.class);
						}
					}
				}
			}
		}*/
		Event[] events = layout.getAllEvents();
		for (int i = 0; i < events.length; i++) {
			if (!events[i].isEnable()) {
				layout.removeChild(events[i]);
			} else if (!events[i].getParam().isEnable()) {
				events[i].removeChild(events[i].getParam());
			} else if (!events[i].getResult().isEnable()) {
				events[i].removeChild(events[i].getResult());				
			}
		}
		
/*		for (Iterator it = layout.getAllEvents(); it != null && it.hasNext();) {
			Event event = (Event) it.next();
			if (!event.isEnable()) {
				it.remove();
			} else {
				if (!event.getParam().isEnable()) {
					event.removeAllByType(Param.class);
				}
				if (!event.getResult().isEnable()) {
					event.removeAllByType(Result.class);
				}
			}
		}*/
	}

	public static String marshallObj(Object obj, IFile file, IProgressMonitor monitor)
			throws Exception {

//		StringWriter strWriter = new StringWriter(1024);
//
//		DefXmlSerializer serializer = new EventDefXmlSerializer(obj, strWriter);
//		serializer.write();
//		String result = strWriter.toString();
		String result = MaskatBeanIO.writeEventDef((EventDef)obj);

		if (!file.exists()) {
			file.create(new ByteArrayInputStream(new byte[0]), false, null);
		}
		file.setContents(new ByteArrayInputStream(result.getBytes("UTF-8")), false,
				false, monitor);
		return result;
	}

	public EventDef getEventDef() {
		return eventDef;
	}

	public LayoutDef getLayoutDef() {
		return layoutDef;
	}
}
