/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.descriptor;

import jp.sf.maskat.ui.Messages;


public class Category {
	
	public static final String BASE_CATEGORY = Messages.getString("property.category.base");
	
	public static final String MISC_CATEGORY = Messages.getString("property.category.misc");

	public static boolean isBaseProperty(String displayName) {
		if ("name".equals(displayName) || "left".equals(displayName)
				|| "top".equals(displayName) || "width".equals(displayName)
				|| "height".equals(displayName) || "tabIndex".equals(displayName)) {
			return true;
		}
		return false;
	}
	
	public static String getCategory(String displayName) {
		if (Category.isBaseProperty(displayName)) {
			return Category.BASE_CATEGORY;
		} else {
			return Category.MISC_CATEGORY;
		}
	}

}
