/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SetEnabledCommand extends Command {
	
	private Control control;
	
	private boolean enabled;
	
	private String text;
	
	/***
	 * @param classType class of the treeNode corresponding to the detailpage, who should be refreshed
	 * @param bean the MaskatElement bean
	 * @param propertyName 
	 * @param newValue
	 */
	public SetEnabledCommand(Control control, boolean enabled) {
		this.control = control;
		this.enabled = enabled;
		if (control instanceof Text) {
			this.text = ((Text) control).getText();
		}
	}

	public void execute() {
		try {
			if (control.getEnabled() != this.enabled) {
				enabledControl(control, this.enabled);
			}
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));			
		}		
	}
	
	public void undo() {
		try {
			if (control.getEnabled() != !this.enabled) {
				enabledControl(control, !this.enabled);
			}			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	private void enabledControl(Control control, boolean enabled) {
		if (control instanceof Text) {
			enabledControl((Text) control, enabled);
		} else {
			control.setEnabled(enabled);
		}
	}
	
	private void enabledControl(Text text, boolean enabled) {
		if (enabled) {
			text.setText(this.text);
		} else {
			text.setText("");
		}
		text.setEnabled(enabled);
	}
}
