/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Button;

public class SetSelectionCommand extends Command {
	
	private Button control;
	
	private boolean selected;
	
	/***
	 * @param classType class of the treeNode corresponding to the detailpage, who should be refreshed
	 * @param bean the MaskatElement bean
	 * @param propertyName 
	 * @param newValue
	 */
	public SetSelectionCommand(Button control, boolean selected) {
		this.control = control;
		this.selected = selected;
	}

	public void execute() {
		try {
			if (control.getSelection() != this.selected) {
				control.setSelection(this.selected);
			}
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));			
		}		
	}
	
	public void undo() {
		try {
			if (control.getSelection() != !this.selected) {
				control.setSelection(!this.selected);
			}			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}
}
