/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;

import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;


public class RadioMemberEditPart extends LayoutElementEditPart {
	protected IFigure createFigure() {
		return new Figure();
	}
	
	public String getOutlineLabel() {
		StringBuffer sb = new StringBuffer(super.getOutlineLabel());
		sb.append(" - ("); //$NON-NLS-1$
		sb.append(getRef());
		sb.append(")"); //$NON-NLS-1$
		return sb.toString();
	}
	
	public boolean canDelete() {
		return false;
	}
	
	public String getRef() {
		return (String) ((DynaComponent) getModel()).get("ref");
	}

	public void setRef(String ref) {
		((DynaComponent) getModel()).set("ref", ref);
	}
}
