/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.arnx.jsonic.Base64;
import net.arnx.jsonic.CharSequenceParserSource;
import net.arnx.jsonic.JSONConvertException;
import net.arnx.jsonic.JSONParseException;
import net.arnx.jsonic.ParserSource;
import net.arnx.jsonic.ReaderParserSource;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSON {
    private static final Character ROOT_KEY = Character.valueOf('$');
    private static final Map<Class, Object> PRIMITIVE_MAP = new IdentityHashMap<Class, Object>();
    private Object context = null;
    private Locale locale;
    private boolean prettyPrint = false;
    private int maxDepth = 32;
    private transient Class<?> scope = null;

    public JSON() {
    }

    public JSON(int n) {
        this.setMaxDepth(n);
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setPrettyPrint(boolean bl) {
        this.prettyPrint = bl;
    }

    public void setMaxDepth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "maxDepth", 0));
        }
        this.maxDepth = n;
    }

    public static String encode(Object object) {
        return JSON.encode(object, false);
    }

    public static String encode(Object object, boolean bl) {
        JSON jSON = new JSON();
        jSON.setPrettyPrint(bl);
        return jSON.format(object);
    }

    public static void encode(Object object, Appendable appendable) throws IOException {
        new JSON().format(object, appendable);
    }

    public static void encode(Object object, Appendable appendable, boolean bl) throws IOException {
        JSON jSON = new JSON();
        jSON.setPrettyPrint(bl);
        jSON.format(object, appendable);
    }

    public static Object decode(String string) throws JSONParseException {
        return new JSON().parse(string);
    }

    public static <T> T decode(String string, Class<? extends T> clazz) throws JSONParseException {
        return new JSON().parse((CharSequence)string, clazz);
    }

    public static Object decode(String string, Type type) throws JSONParseException {
        return new JSON().parse((CharSequence)string, type);
    }

    public static Object decode(InputStream inputStream) throws IOException, JSONParseException {
        return new JSON().parse(inputStream);
    }

    public static <T> T decode(InputStream inputStream, Class<? extends T> clazz) throws IOException, JSONParseException {
        return new JSON().parse(inputStream, clazz);
    }

    public static Object decode(InputStream inputStream, Type type) throws IOException, JSONParseException {
        return new JSON().parse(inputStream, type);
    }

    public static Object decode(Reader reader) throws IOException, JSONParseException {
        return new JSON().parse(reader);
    }

    public static <T> T decode(Reader reader, Class<? extends T> clazz) throws IOException, JSONParseException {
        return new JSON().parse(reader, clazz);
    }

    public static Object decode(Reader reader, Type type) throws IOException, JSONParseException {
        return new JSON().parse(reader, type);
    }

    public String format(Object object) {
        String string = null;
        try {
            string = this.format(object, new StringBuilder(1000)).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Appendable format(Object object, Appendable appendable) throws IOException {
        if (this.context != null) {
            this.scope = this.context.getClass();
        }
        if (this.scope == null) {
            this.scope = object.getClass().getEnclosingClass();
        }
        if (this.scope == null) {
            this.scope = object.getClass();
        }
        try {
            appendable = this.format(object, appendable, 0);
        }
        finally {
            this.scope = null;
        }
        return appendable;
    }

    /*
     * WARNING - void declaration
     */
    private Appendable format(Object object, Appendable appendable, int n) throws IOException {
        Object object2;
        Object object3;
        AbstractMap abstractMap;
        Object object4;
        if (n > this.maxDepth) {
            object = null;
        }
        boolean bl = true;
        if (object instanceof Class) {
            object = ((Class)object).getName();
        } else if (object instanceof Character || object instanceof Type || object instanceof Member || object instanceof URL || object instanceof URI) {
            object = object.toString();
        } else if (object instanceof Enum) {
            object = ((Enum)object).ordinal();
        } else if (object instanceof char[]) {
            object = new String((char[])object);
        } else if (object instanceof byte[]) {
            bl = false;
            object = Base64.encode((byte[])object);
        } else if (object instanceof Iterable) {
            object = ((Iterable)object).iterator();
        } else if (object instanceof Object[]) {
            object = Arrays.asList((Object[])object).iterator();
        } else if (object instanceof Pattern) {
            object = ((Pattern)object).pattern();
        } else if (object instanceof TimeZone) {
            object = ((TimeZone)object).getID();
        } else if (object instanceof Date) {
            object = ((Date)object).getTime();
        } else if (object instanceof Calendar) {
            object = ((Calendar)object).getTimeInMillis();
        } else if (object instanceof InetAddress) {
            object = ((InetAddress)object).getHostAddress();
        } else if (object instanceof Charset) {
            object = ((Charset)object).name();
        } else if (object instanceof Locale) {
            object4 = (Locale)object;
            object = ((Locale)object4).getLanguage() != null && ((Locale)object4).getLanguage().length() > 0 ? (((Locale)object4).getCountry() != null && ((Locale)object4).getCountry().length() > 0 ? ((Locale)object4).getLanguage() + "-" + ((Locale)object4).getCountry() : ((Locale)object4).getLanguage()) : null;
        } else if (object instanceof Node) {
            object4 = null;
            if (object instanceof Document) {
                object4 = ((Document)object).getDocumentElement();
            } else if (object instanceof Element) {
                object4 = (Element)object;
            }
            if (object4 != null) {
                int n2;
                abstractMap = new LinkedHashMap();
                abstractMap.put("tagName", object4.getTagName());
                if (object4.hasAttributes()) {
                    object3 = object4.getAttributes();
                    LinkedHashMap<String, String> arrayList = new LinkedHashMap<String, String>();
                    for (n2 = 0; n2 < object3.getLength(); ++n2) {
                        object2 = object3.item(n2);
                        if (object2.getNodeType() != 2) continue;
                        arrayList.put(object2.getNodeName(), object2.getNodeValue());
                    }
                    abstractMap.put("attributes", arrayList);
                }
                if (object4.hasChildNodes()) {
                    object3 = object4.getChildNodes();
                    ArrayList<Object> i = new ArrayList<Object>(object3.getLength());
                    for (n2 = 0; n2 < object3.getLength(); ++n2) {
                        object2 = object3.item(n2);
                        if (object2.getNodeType() == 1) {
                            i.add((Element)object2);
                            continue;
                        }
                        if (object2.getNodeType() != 3 && object2.getNodeType() != 4) continue;
                        i.add(((CharacterData)object2).getData());
                    }
                    abstractMap.put("childNodes", i);
                }
                object = abstractMap;
            }
        }
        if (n == 0 && (object == null || object instanceof CharSequence || object instanceof Boolean || object instanceof Number || object instanceof Date)) {
            throw new IllegalArgumentException(this.getMessage("json.format.IllegalRootTypeError", new Object[0]));
        }
        if (object == null) {
            appendable.append("null");
        } else if (object instanceof CharSequence) {
            if (bl) {
                this.formatString((CharSequence)object, appendable);
            } else {
                appendable.append('\"').append((CharSequence)object).append('\"');
            }
        } else if (object instanceof Double || object instanceof Float) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                appendable.append('\"').append(object.toString()).append('\"');
            } else {
                appendable.append(object.toString());
            }
        } else if (object instanceof Byte) {
            appendable.append(Integer.toString((Byte)object & 0xFF));
        } else if (object instanceof Number || object instanceof Boolean) {
            appendable.append(object.toString());
        } else if (object.getClass().isArray()) {
            appendable.append('[');
            if (object instanceof boolean[]) {
                object4 = (boolean[])object;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    appendable.append(String.valueOf((boolean)object4[i]));
                    if (i == ((Object)object4).length - 1) continue;
                    appendable.append(',');
                    if (!this.prettyPrint) continue;
                    appendable.append(' ');
                }
            } else if (object instanceof short[]) {
                object4 = (short[])object;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    appendable.append(String.valueOf((int)object4[i]));
                    if (i == ((Object)object4).length - 1) continue;
                    appendable.append(',');
                    if (!this.prettyPrint) continue;
                    appendable.append(' ');
                }
            } else if (object instanceof int[]) {
                object4 = (int[])object;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    appendable.append(String.valueOf((int)object4[i]));
                    if (i == ((Object)object4).length - 1) continue;
                    appendable.append(',');
                    if (!this.prettyPrint) continue;
                    appendable.append(' ');
                }
            } else if (object instanceof long[]) {
                object4 = (long[])object;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    appendable.append(String.valueOf((long)object4[i]));
                    if (i == ((Object)object4).length - 1) continue;
                    appendable.append(',');
                    if (!this.prettyPrint) continue;
                    appendable.append(' ');
                }
            } else if (object instanceof float[]) {
                object4 = (float[])object;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    if (Float.isNaN((float)object4[i]) || Float.isInfinite((float)object4[i])) {
                        appendable.append('\"').append(Float.toString((float)object4[i])).append('\"');
                    } else {
                        appendable.append(String.valueOf((float)object4[i]));
                    }
                    if (i == ((Object)object4).length - 1) continue;
                    appendable.append(',');
                    if (!this.prettyPrint) continue;
                    appendable.append(' ');
                }
            } else if (object instanceof double[]) {
                object4 = (double[])object;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    if (Double.isNaN((double)object4[i]) || Double.isInfinite((double)object4[i])) {
                        appendable.append('\"').append(Double.toString((double)object4[i])).append('\"');
                    } else {
                        appendable.append(String.valueOf((double)object4[i]));
                    }
                    if (i == ((Object)object4).length - 1) continue;
                    appendable.append(',');
                    if (!this.prettyPrint) continue;
                    appendable.append(' ');
                }
            }
            appendable.append(']');
        } else if (object instanceof Iterator) {
            boolean bl2;
            object4 = object;
            appendable.append('[');
            boolean bl3 = bl2 = !object4.hasNext();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (this.prettyPrint) {
                    void var8_23;
                    appendable.append('\n');
                    boolean bl4 = false;
                    while (var8_23 < n + 1) {
                        appendable.append('\t');
                        ++var8_23;
                    }
                }
                if (object3 == object) {
                    object3 = null;
                }
                this.format(object3, appendable, n + 1);
                if (!object4.hasNext()) continue;
                appendable.append(',');
            }
            if (this.prettyPrint && !bl2) {
                appendable.append('\n');
                for (int i = 0; i < n; ++i) {
                    appendable.append('\t');
                }
            }
            appendable.append(']');
        } else if (object instanceof Enumeration) {
            boolean bl4;
            object4 = (Enumeration)object;
            appendable.append('[');
            boolean bl5 = bl4 = !object4.hasMoreElements();
            while (object4.hasMoreElements()) {
                object3 = object4.nextElement();
                if (this.prettyPrint) {
                    void var8_25;
                    appendable.append('\n');
                    boolean bl6 = false;
                    while (var8_25 < n + 1) {
                        appendable.append('\t');
                        ++var8_25;
                    }
                }
                if (object3 == object) {
                    object3 = null;
                }
                this.format(object3, appendable, n + 1);
                if (!object4.hasMoreElements()) continue;
                appendable.append(',');
            }
            if (this.prettyPrint && !bl4) {
                appendable.append('\n');
                for (int i = 0; i < n; ++i) {
                    appendable.append('\t');
                }
            }
            appendable.append(']');
        } else if (object instanceof Map) {
            this.formatMap((Map)object, object, appendable, n);
        } else {
            object4 = object.getClass();
            abstractMap = new TreeMap();
            for (Map.Entry entry : this.getGetProperties((Class<?>)object4).entrySet()) {
                Object object5 = null;
                try {
                    if (entry.getValue() instanceof Method) {
                        object2 = (Method)entry.getValue();
                        object5 = ((Method)object2).invoke(object, new Object[0]);
                    } else {
                        object2 = (Field)entry.getValue();
                        object5 = ((Field)object2).get(object);
                    }
                    abstractMap.put(entry.getKey(), object5);
                }
                catch (Exception exception) {}
            }
            this.formatMap(abstractMap, object, appendable, n);
        }
        if (appendable instanceof Flushable) {
            ((Flushable)((Object)appendable)).flush();
        }
        return appendable;
    }

    private Appendable formatMap(Map map, Object object, Appendable appendable, int n) throws IOException {
        appendable.append('{');
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() == object) continue;
            if (this.prettyPrint) {
                appendable.append('\n');
                for (int i = 0; i < n + 1; ++i) {
                    appendable.append('\t');
                }
            }
            this.formatString(entry.getKey().toString(), appendable).append(':');
            if (this.prettyPrint) {
                appendable.append(' ');
            }
            this.format(entry.getValue(), appendable, n + 1);
            if (!iterator.hasNext()) continue;
            appendable.append(',');
        }
        if (this.prettyPrint && !map.isEmpty()) {
            appendable.append('\n');
            for (int i = 0; i < n; ++i) {
                appendable.append('\t');
            }
        }
        appendable.append('}');
        return appendable;
    }

    private Appendable formatString(CharSequence charSequence, Appendable appendable) throws IOException {
        appendable.append('\"');
        block8: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    appendable.append('\\').append(c);
                    continue block8;
                }
                case '\b': {
                    appendable.append("\\b");
                    continue block8;
                }
                case '\f': {
                    appendable.append("\\f");
                    continue block8;
                }
                case '\n': {
                    appendable.append("\\n");
                    continue block8;
                }
                case '\r': {
                    appendable.append("\\r");
                    continue block8;
                }
                case '\t': {
                    appendable.append("\\t");
                    continue block8;
                }
                default: {
                    appendable.append(c);
                }
            }
        }
        appendable.append('\"');
        return appendable;
    }

    public Object parse(CharSequence charSequence) throws JSONParseException {
        Object object = null;
        try {
            object = this.parse(new CharSequenceParserSource(charSequence));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    public <T> T parse(CharSequence charSequence, Class<? extends T> clazz) throws JSONParseException {
        return (T)this.parse(charSequence, (Type)clazz);
    }

    public Object parse(CharSequence charSequence, Type type) throws JSONParseException {
        Object object = null;
        try {
            object = this.parse(new CharSequenceParserSource(charSequence), type);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    public Object parse(InputStream inputStream) throws IOException, JSONParseException {
        return this.parse(new ReaderParserSource(inputStream));
    }

    public <T> T parse(InputStream inputStream, Class<? extends T> clazz) throws IOException, JSONParseException, JSONConvertException {
        return (T)this.parse(inputStream, (Type)clazz);
    }

    public Object parse(InputStream inputStream, Type type) throws IOException, JSONParseException, JSONConvertException {
        return this.parse(new ReaderParserSource(inputStream), type);
    }

    public Object parse(Reader reader) throws IOException, JSONParseException {
        return this.parse(new ReaderParserSource(reader));
    }

    public <T> T parse(Reader reader, Class<? extends T> clazz) throws IOException, JSONParseException {
        return (T)this.parse(reader, (Type)clazz);
    }

    public Object parse(Reader reader, Type type) throws IOException, JSONParseException {
        return this.parse(new ReaderParserSource(reader), type);
    }

    private Object parse(ParserSource parserSource, Type type) throws IOException, JSONParseException {
        return this.convert(this.parse(parserSource), type);
    }

    private Object parse(ParserSource parserSource) throws IOException, JSONParseException {
        Map<String, Object> map = null;
        int n = -1;
        block5: while ((n = parserSource.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\ufeff': {
                    continue block5;
                }
                case '[': {
                    if (map == null) {
                        parserSource.back();
                        map = this.parseArray(parserSource, 1);
                        continue block5;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '#': 
                case '/': {
                    parserSource.back();
                    this.skipComment(parserSource);
                    continue block5;
                }
            }
            if (map == null) {
                parserSource.back();
                map = this.parseObject(parserSource, 1);
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
        }
        return map == null ? new LinkedHashMap() : map;
    }

    private Map<String, Object> parseObject(ParserSource parserSource, int n) throws IOException, JSONParseException {
        int n2 = 0;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        String string = null;
        int n3 = 0;
        int n4 = -1;
        block11: while ((n4 = parserSource.next()) != -1) {
            char c = (char)n4;
            switch (c) {
                case '\n': 
                case '\r': {
                    if (n2 == 5) {
                        n2 = 6;
                    }
                }
                case '\t': 
                case ' ': 
                case '\ufeff': {
                    continue block11;
                }
                case '{': {
                    Object object;
                    if (n2 == 0) {
                        n3 = 123;
                        n2 = 1;
                        continue block11;
                    }
                    if (n2 == 2 || n2 == 3) {
                        parserSource.back();
                        object = this.parseObject(parserSource, n + 1);
                        if (n < this.maxDepth) {
                            linkedHashMap.put(string, object);
                        }
                        n2 = 5;
                        continue block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case ':': {
                    if (n2 == 2) {
                        n2 = 3;
                        continue block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case ',': {
                    if (n2 == 3) {
                        if (n < this.maxDepth) {
                            linkedHashMap.put(string, null);
                        }
                        n2 = 1;
                        continue block11;
                    }
                    if (n2 == 5 || n2 == 6) {
                        n2 = 1;
                        continue block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '}': {
                    if (n3 == 123 && (n2 == 1 || n2 == 3 || n2 == 5 || n2 == 6)) {
                        if (n2 != 3 || n >= this.maxDepth) break block11;
                        linkedHashMap.put(string, null);
                        break block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '\"': 
                case '\'': {
                    Object object;
                    if (n2 == 0) {
                        parserSource.back();
                        n2 = 1;
                        continue block11;
                    }
                    if (n2 == 1 || n2 == 6) {
                        parserSource.back();
                        string = this.parseString(parserSource);
                        n2 = 2;
                        continue block11;
                    }
                    if (n2 == 3) {
                        parserSource.back();
                        object = this.parseString(parserSource);
                        if (n < this.maxDepth) {
                            linkedHashMap.put(string, object);
                        }
                        n2 = 5;
                        continue block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '[': {
                    Object object;
                    if (n2 == 3) {
                        parserSource.back();
                        object = this.parseArray(parserSource, n + 1);
                        if (n < this.maxDepth) {
                            linkedHashMap.put(string, object);
                        }
                        n2 = 5;
                        continue block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '#': 
                case '/': {
                    parserSource.back();
                    this.skipComment(parserSource);
                    if (n2 != 5) continue block11;
                    n2 = 6;
                    continue block11;
                }
                default: {
                    Object object;
                    if (n2 == 0) {
                        parserSource.back();
                        n2 = 1;
                        continue block11;
                    }
                    if (n2 == 1 || n2 == 6) {
                        parserSource.back();
                        string = this.parseLiteral(parserSource);
                        n2 = 2;
                        continue block11;
                    }
                    if (n2 == 3) {
                        if (c == '-' || c >= '0' && c <= '9') {
                            parserSource.back();
                            object = this.parseNumber(parserSource);
                            if (n < this.maxDepth) {
                                linkedHashMap.put(string, object);
                            }
                        } else {
                            parserSource.back();
                            object = this.parseLiteral(parserSource);
                            if (((String)object).equals("null")) {
                                linkedHashMap.put(string, null);
                            } else if (((String)object).equals("true")) {
                                linkedHashMap.put(string, Boolean.TRUE);
                            } else if (((String)object).equals("false")) {
                                linkedHashMap.put(string, Boolean.FALSE);
                            } else {
                                linkedHashMap.put(string, object);
                            }
                        }
                        n2 = 5;
                        continue block11;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
            }
        }
        if (n4 == -1 ? n3 != 0 : n4 != 125) {
            throw this.createParseException(this.getMessage("json.parse.ObjectNotClosedError", new Object[0]), parserSource);
        }
        return linkedHashMap;
    }

    private List<Object> parseArray(ParserSource parserSource, int n) throws IOException, JSONParseException {
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = -1;
        block10: while ((n3 = parserSource.next()) != -1) {
            char c = (char)n3;
            switch (c) {
                case '\n': 
                case '\r': {
                    if (n2 == 2) {
                        n2 = 3;
                    }
                }
                case '\t': 
                case ' ': 
                case '\ufeff': {
                    continue block10;
                }
                case '[': {
                    Object object;
                    if (n2 == 0) {
                        n2 = 1;
                        continue block10;
                    }
                    if (n2 == 1 || n2 == 3) {
                        parserSource.back();
                        object = this.parseArray(parserSource, n + 1);
                        if (n < this.maxDepth) {
                            arrayList.add(object);
                        }
                        n2 = 2;
                        continue block10;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case ',': {
                    if (n2 == 1) {
                        if (n >= this.maxDepth) continue block10;
                        arrayList.add(null);
                        continue block10;
                    }
                    if (n2 == 2 || n2 == 3) {
                        n2 = 1;
                        continue block10;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case ']': {
                    if (n2 == 1) {
                        if (arrayList.isEmpty() || n >= this.maxDepth) break block10;
                        arrayList.add(null);
                        break block10;
                    }
                    if (n2 == 2 || n2 == 3) break block10;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '{': {
                    Object object;
                    if (n2 == 1 || n2 == 3) {
                        parserSource.back();
                        object = this.parseObject(parserSource, n + 1);
                        if (n < this.maxDepth) {
                            arrayList.add(object);
                        }
                        n2 = 2;
                        continue block10;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '\"': 
                case '\'': {
                    Object object;
                    if (n2 == 1 || n2 == 3) {
                        parserSource.back();
                        object = this.parseString(parserSource);
                        if (n < this.maxDepth) {
                            arrayList.add(object);
                        }
                        n2 = 2;
                        continue block10;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '#': 
                case '/': {
                    parserSource.back();
                    this.skipComment(parserSource);
                    if (n2 != 2) continue block10;
                    n2 = 3;
                    continue block10;
                }
                default: {
                    Object object;
                    if (n2 == 1 || n2 == 3) {
                        if (c == '-' || c >= '0' && c <= '9') {
                            parserSource.back();
                            object = this.parseNumber(parserSource);
                            if (n < this.maxDepth) {
                                arrayList.add(object);
                            }
                        } else {
                            parserSource.back();
                            object = this.parseLiteral(parserSource);
                            if (n < this.maxDepth) {
                                if (((String)object).equals("null")) {
                                    arrayList.add(null);
                                } else if (((String)object).equals("true")) {
                                    arrayList.add(Boolean.TRUE);
                                } else if (((String)object).equals("false")) {
                                    arrayList.add(Boolean.FALSE);
                                } else {
                                    arrayList.add(object);
                                }
                            }
                        }
                        n2 = 2;
                        continue block10;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
            }
        }
        if (n3 != 93) {
            throw this.createParseException(this.getMessage("json.parse.ArrayNotClosedError", new Object[0]), parserSource);
        }
        return arrayList;
    }

    private String parseString(ParserSource parserSource) throws IOException, JSONParseException {
        int n;
        boolean bl = false;
        StringBuilder stringBuilder = parserSource.getCachedBuilder();
        int c = 0;
        int c2 = -1;
        block5: while ((n = parserSource.next()) != -1) {
            char c3 = (char)n;
            switch (c3) {
                case '\ufeff': {
                    continue block5;
                }
                case '\\': {
                    if (bl) {
                        if (c == 34) {
                            parserSource.back();
                            stringBuilder.append(this.parseEscape(parserSource));
                            continue block5;
                        }
                        stringBuilder.append(c3);
                        continue block5;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c3)), parserSource);
                }
                case '\"': 
                case '\'': {
                    if (!bl) {
                        c = c3;
                        bl = true;
                        continue block5;
                    }
                    if (bl && c == c3) break block5;
                }
                default: {
                    if (bl) {
                        stringBuilder.append(c3);
                        continue block5;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c3)), parserSource);
                }
            }
        }
        if (n == -1 && n != c) {
            throw this.createParseException(this.getMessage("json.parse.StringNotClosedError", new Object[0]), parserSource);
        }
        return stringBuilder.toString();
    }

    private String parseLiteral(ParserSource parserSource) throws IOException, JSONParseException {
        boolean bl = false;
        StringBuilder stringBuilder = parserSource.getCachedBuilder();
        int n = -1;
        block4: while ((n = parserSource.next()) != -1) {
            char c = (char)n;
            switch (c) {
                case '\ufeff': {
                    continue block4;
                }
                case '\\': {
                    parserSource.back();
                    c = this.parseEscape(parserSource);
                }
            }
            if (!bl && Character.isJavaIdentifierStart(c)) {
                stringBuilder.append(c);
                bl = true;
                continue;
            }
            if (bl && Character.isJavaIdentifierPart(c)) {
                stringBuilder.append(c);
                continue;
            }
            parserSource.back();
            break;
        }
        return stringBuilder.toString();
    }

    private Number parseNumber(ParserSource parserSource) throws IOException, JSONParseException {
        int n = 0;
        StringBuilder stringBuilder = parserSource.getCachedBuilder();
        int n2 = -1;
        block7: while ((n2 = parserSource.next()) != -1) {
            char c = (char)n2;
            switch (c) {
                case '\ufeff': {
                    continue block7;
                }
                case '+': {
                    if (n == 7) {
                        stringBuilder.append(c);
                        n = 8;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '-': {
                    if (n == 0) {
                        stringBuilder.append(c);
                        n = 1;
                        continue block7;
                    }
                    if (n == 7) {
                        stringBuilder.append(c);
                        n = 8;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '.': {
                    if (n == 2 || n == 3) {
                        stringBuilder.append(c);
                        n = 4;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case 'E': 
                case 'e': {
                    if (n == 2 || n == 3 || n == 5 || n == 6) {
                        stringBuilder.append(c);
                        n = 7;
                        continue block7;
                    }
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
            }
            if (c >= '0' && c <= '9') {
                if (n == 0 || n == 1) {
                    stringBuilder.append(c);
                    n = c == '0' ? 3 : 2;
                    continue;
                }
                if (n == 2 || n == 5) {
                    stringBuilder.append(c);
                    continue;
                }
                if (n == 4) {
                    stringBuilder.append(c);
                    n = 5;
                    continue;
                }
                if (n == 7 || n == 8) {
                    stringBuilder.append(c);
                    break;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
            }
            if (n == 2 || n == 3 || n == 5 || n == 6) {
                parserSource.back();
                break;
            }
            throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
        }
        return new BigDecimal(stringBuilder.toString());
    }

    private char parseEscape(ParserSource parserSource) throws IOException, JSONParseException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        block9: while ((n3 = parserSource.next()) != -1) {
            int n4;
            int n5 = n3;
            if (n5 == 65279) continue;
            if (n == 0) {
                if (n5 == 92) {
                    n = 1;
                    continue;
                }
                throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf((char)n5)), parserSource);
            }
            if (n == 1) {
                switch (n5) {
                    case 34: 
                    case 47: 
                    case 92: {
                        n2 = n5;
                        break;
                    }
                    case 98: {
                        n2 = 8;
                        break;
                    }
                    case 102: {
                        n2 = 12;
                        break;
                    }
                    case 110: {
                        n2 = 10;
                        break;
                    }
                    case 114: {
                        n2 = 13;
                        break;
                    }
                    case 116: {
                        n2 = 9;
                        break;
                    }
                    case 117: {
                        n = 2;
                        continue block9;
                    }
                    default: {
                        n2 = n5;
                        break;
                    }
                }
                break;
            }
            int n6 = n5 >= 48 && n5 <= 57 ? n5 - 48 : (n5 >= 65 && n5 <= 70 ? n5 - 65 + 10 : (n4 = n5 >= 97 && n5 <= 102 ? n5 - 97 + 10 : -1));
            if (n4 != -1) {
                n2 = (char)(n2 | n4 << (5 - n) * 8);
                if (n == 5) break;
                ++n;
                continue;
            }
            throw this.createParseException(this.getMessage("json.parse.IllegalUnicodeEscape", Character.valueOf((char)n5)), parserSource);
        }
        return (char)n2;
    }

    private void skipComment(ParserSource parserSource) throws IOException, JSONParseException {
        int n = 0;
        int n2 = -1;
        block7: while ((n2 = parserSource.next()) != -1) {
            char c = (char)n2;
            switch (c) {
                case '\ufeff': {
                    continue block7;
                }
                case '/': {
                    if (n == 0) {
                        n = 1;
                        continue block7;
                    }
                    if (n == 1) {
                        n = 4;
                        continue block7;
                    }
                    if (n == 3) break block7;
                    if (n == 2 || n == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '*': {
                    if (n == 1) {
                        n = 2;
                        continue block7;
                    }
                    if (n == 2) {
                        n = 3;
                        continue block7;
                    }
                    if (n == 3 || n == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '\n': 
                case '\r': {
                    if (n == 2 || n == 3) {
                        n = 2;
                        continue block7;
                    }
                    if (n == 4) break block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
                case '#': {
                    if (n == 0) {
                        n = 4;
                        continue block7;
                    }
                }
                default: {
                    if (n == 3) {
                        n = 2;
                        continue block7;
                    }
                    if (n == 2 || n == 4) continue block7;
                    throw this.createParseException(this.getMessage("json.parse.UnexpectedChar", Character.valueOf(c)), parserSource);
                }
            }
        }
    }

    private JSONParseException createParseException(String string, ParserSource parserSource) {
        return new JSONParseException("" + parserSource.getLineNumber() + ": " + string + "\n" + parserSource.toString() + " <- ?", parserSource.getLineNumber(), parserSource.getColumnNumber(), parserSource.getOffset());
    }

    private String getMessage(String string, Object ... objectArray) {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("net.arnx.jsonic.Messages", this.locale);
        return MessageFormat.format(resourceBundle.getString(string), objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object convert(Object object, Type type) throws JSONConvertException {
        Class<?> clazz = JSON.getRawType(type);
        if (this.context != null) {
            this.scope = this.context.getClass();
        }
        if (this.scope == null) {
            this.scope = clazz.getEnclosingClass();
        }
        if (this.scope == null) {
            this.scope = clazz;
        }
        Object var4_4 = null;
        try {
            var4_4 = this.convertChild(ROOT_KEY, object, clazz, type);
        }
        finally {
            this.scope = null;
        }
        return var4_4;
    }

    protected final <T> T convertChild(Object object, Object object2, Class<? extends T> clazz, Type type) throws JSONConvertException {
        T t = null;
        Class<T> clazz2 = clazz.isPrimitive() ? PRIMITIVE_MAP.get(clazz).getClass() : clazz;
        try {
            t = clazz2.cast(this.convert(object, object2, clazz, type));
        }
        catch (JSONConvertException jSONConvertException) {
            jSONConvertException.add(object);
            throw jSONConvertException;
        }
        catch (Exception exception) {
            JSONConvertException jSONConvertException = new JSONConvertException(this.getMessage("json.convert.ConversionError", object2 instanceof String ? "\"" + object2 + "\"" : object2, type), exception);
            jSONConvertException.add(object);
            throw jSONConvertException;
        }
        return t;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T convert(Object object, Object object2, Class<? extends T> clazz, Type type) throws Exception {
        void var5_109;
        Object var5_5 = null;
        if (object2 == null) {
            if (!clazz.isPrimitive()) return var5_109;
            Object object3 = PRIMITIVE_MAP.get(clazz);
            return var5_109;
        }
        if (clazz.equals(type) && clazz.isAssignableFrom(object2.getClass())) {
            Object object4 = object2;
            return var5_109;
        }
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            if (Map.class.isAssignableFrom(clazz)) {
                Map map2 = null;
                if (type instanceof ParameterizedType) {
                    Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                    Class<Object> clazz2 = typeArray != null && typeArray.length > 0 ? typeArray[0] : Object.class;
                    Class<Object> clazz3 = typeArray != null && typeArray.length > 1 ? typeArray[1] : Object.class;
                    Class<?> clazz4 = JSON.getRawType(clazz2);
                    Class<?> clazz5 = JSON.getRawType(clazz3);
                    if ((Object.class.equals(clazz4) || String.class.equals(clazz4)) && Object.class.equals(clazz5)) {
                        map2 = (Map)object2;
                    } else {
                        map2 = (Map)this.create(clazz);
                        for (Map.Entry entry : map.entrySet()) {
                            map2.put(this.convertChild(object, entry.getKey(), (Class<? extends T>)clazz4, (Type)((Object)clazz2)), this.convertChild(entry.getKey(), entry.getValue(), (Class<? extends T>)clazz5, (Type)((Object)clazz3)));
                        }
                    }
                } else {
                    map2 = (Map)this.create(clazz);
                    map2.putAll(map);
                }
                Map map3 = map2;
                return var5_109;
            } else {
                Object object5 = this.create(clazz);
                if (object5 == null) throw new UnsupportedOperationException();
                Map<String, Member> map4 = this.getSetProperties(clazz);
                for (Map.Entry entry : map.entrySet()) {
                    AccessibleObject accessibleObject;
                    String string = entry.getKey().toString();
                    Member member = this.mapping(clazz, map4, string);
                    if (member == null) continue;
                    if (member instanceof Method) {
                        accessibleObject = (Method)member;
                        ((Method)accessibleObject).invoke(object5, this.convertChild(string, entry.getValue(), ((Method)accessibleObject).getParameterTypes()[0], ((Method)accessibleObject).getGenericParameterTypes()[0]));
                        continue;
                    }
                    accessibleObject = (Field)member;
                    ((Field)accessibleObject).set(object5, this.convertChild(string, entry.getValue(), ((Field)accessibleObject).getType(), ((Field)accessibleObject).getGenericType()));
                }
                Object object6 = object5;
            }
            return var5_109;
        }
        if (object2 instanceof List) {
            List list = (List)object2;
            if (Collection.class.isAssignableFrom(clazz)) {
                Collection collection = null;
                if (type instanceof ParameterizedType) {
                    Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                    Object object7 = typeArray != null && typeArray.length > 0 ? typeArray[0] : Object.class;
                    Class<?> clazz6 = JSON.getRawType(object7);
                    if (Object.class.equals(clazz6)) {
                        collection = list;
                    } else {
                        collection = (Collection)this.create(clazz);
                        for (int i = 0; i < list.size(); ++i) {
                            collection.add(this.convertChild(i, list.get(i), (Class<? extends T>)clazz6, (Type)object7));
                        }
                    }
                } else {
                    collection = (Collection)this.create(clazz);
                    collection.addAll(list);
                }
                Collection collection2 = collection;
                return var5_109;
            }
            if (clazz.isArray()) {
                Object object8 = Array.newInstance(clazz.getComponentType(), list.size());
                Class<?> clazz7 = clazz.getComponentType();
                Class<?> clazz8 = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : clazz7;
                for (int i = 0; i < list.size(); ++i) {
                    Array.set(object8, i, this.convertChild(i, list.get(i), clazz7, clazz8));
                }
                Object object9 = object8;
                return var5_109;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Map map = (Map)this.create(clazz);
                if (type instanceof ParameterizedType) {
                    Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                    Class<Object> clazz9 = typeArray != null && typeArray.length > 0 ? typeArray[0] : Object.class;
                    Class<Object> clazz10 = typeArray != null && typeArray.length > 1 ? typeArray[1] : Object.class;
                    Class<?> clazz11 = JSON.getRawType(clazz9);
                    Class<?> clazz12 = JSON.getRawType(clazz10);
                    for (int i = 0; i < list.size(); ++i) {
                        map.put(this.convertChild(object, i, (Class<? extends T>)clazz11, (Type)((Object)clazz9)), this.convertChild(i, list.get(i), (Class<? extends T>)clazz12, (Type)((Object)clazz10)));
                    }
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        map.put(i, list.get(i));
                    }
                }
                Map map5 = map;
                return var5_109;
            }
            if (!Locale.class.equals(clazz)) throw new UnsupportedOperationException();
            if (list.size() == 1) {
                Locale locale = new Locale(list.get(0).toString());
                return var5_109;
            } else if (list.size() == 2) {
                Locale locale = new Locale(list.get(0).toString(), list.get(1).toString());
                return var5_109;
            } else {
                if (list.size() <= 2) return var5_109;
                Locale locale = new Locale(list.get(0).toString(), list.get(1).toString(), list.get(2).toString());
            }
            return var5_109;
        }
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            if (object2 instanceof Number) {
                Boolean bl = !object2.equals(0);
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() == 0 || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("off") || string.equals("NaN")) {
                    Boolean bl = false;
                    return var5_109;
                } else {
                    Boolean bl = true;
                }
            }
            return var5_109;
        } else if (Byte.TYPE.equals(clazz) || Byte.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Integer n = (Boolean)object2 != false ? 1 : 0;
                return var5_109;
            } else if (object2 instanceof BigDecimal) {
                Byte by = ((BigDecimal)object2).byteValueExact();
                return var5_109;
            } else if (object2 instanceof Number) {
                Byte by = ((Number)object2).byteValue();
                return var5_109;
            } else {
                String string = object2.toString().trim().toLowerCase();
                if (string.length() > 0) {
                    int n = 0;
                    if (string.charAt(0) == '+') {
                        ++n;
                    }
                    int n2 = 0;
                    n2 = string.startsWith("0x", n) ? Integer.parseInt(string.substring(n + 2), 16) : Integer.parseInt(string.substring(n));
                    Byte by = (byte)(n2 > 127 ? n2 - 256 : n2);
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Byte by = 0;
                }
            }
            return var5_109;
        } else if (Short.TYPE.equals(clazz) || Short.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Integer n = (Boolean)object2 != false ? 1 : 0;
                return var5_109;
            } else if (object2 instanceof BigDecimal) {
                Short s = ((BigDecimal)object2).shortValueExact();
                return var5_109;
            } else if (object2 instanceof Number) {
                Short s = ((Number)object2).shortValue();
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() > 0) {
                    int n = 0;
                    if (string.charAt(0) == '+') {
                        ++n;
                    }
                    if (string.startsWith("0x", n)) {
                        Short s = (short)Integer.parseInt(string.substring(n + 2), 16);
                        return var5_109;
                    } else {
                        Short s = (short)Integer.parseInt(string.substring(n));
                    }
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Short s = 0;
                }
            }
            return var5_109;
        } else if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Integer n = (Boolean)object2 != false ? 1 : 0;
                return var5_109;
            } else if (object2 instanceof BigDecimal) {
                Integer n = ((BigDecimal)object2).intValueExact();
                return var5_109;
            } else if (object2 instanceof Number) {
                Integer n = ((Number)object2).intValue();
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() > 0) {
                    int n = 0;
                    if (string.charAt(0) == '+') {
                        ++n;
                    }
                    if (string.startsWith("0x", n)) {
                        Integer n3 = Integer.parseInt(string.substring(n + 2), 16);
                        return var5_109;
                    } else {
                        Integer n4 = Integer.parseInt(string.substring(n));
                    }
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Integer n = 0;
                }
            }
            return var5_109;
        } else if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Long l = (Boolean)object2 != false ? 1L : 0L;
                return var5_109;
            } else if (object2 instanceof BigDecimal) {
                Long l = ((BigDecimal)object2).longValueExact();
                return var5_109;
            } else if (object2 instanceof Number) {
                Long l = ((Number)object2).longValue();
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() > 0) {
                    int n = 0;
                    if (string.charAt(0) == '+') {
                        ++n;
                    }
                    if (string.startsWith("0x", n)) {
                        Long l = Long.parseLong(string.substring(n + 2), 16);
                        return var5_109;
                    } else {
                        Long l = Long.parseLong(string.substring(n));
                    }
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Long l = 0L;
                }
            }
            return var5_109;
        } else if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Float f = Float.valueOf((Boolean)object2 != false ? 1.0f : Float.NaN);
                return var5_109;
            } else if (object2 instanceof Number) {
                Float f = Float.valueOf(((Number)object2).floatValue());
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() > 0) {
                    if (string.charAt(0) == '+') {
                        Float f = Float.valueOf(string.substring(1));
                        return var5_109;
                    } else {
                        Float f = Float.valueOf(string);
                    }
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Float f = Float.valueOf(0.0f);
                }
            }
            return var5_109;
        } else if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Double d = (Boolean)object2 != false ? 1.0 : Double.NaN;
                return var5_109;
            } else if (object2 instanceof Number) {
                Double d = ((Number)object2).doubleValue();
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() > 0) {
                    if (string.charAt(0) == '+') {
                        Double d = Double.valueOf(string.substring(1));
                        return var5_109;
                    } else {
                        Double d = Double.valueOf(string);
                    }
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Double d = 0.0;
                }
            }
            return var5_109;
        } else if (BigInteger.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                BigInteger bigInteger = (Boolean)object2 != false ? BigInteger.ONE : BigInteger.ZERO;
                return var5_109;
            } else if (object2 instanceof BigDecimal) {
                BigInteger bigInteger = ((BigDecimal)object2).toBigIntegerExact();
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() <= 0) return var5_109;
                int n = 0;
                if (string.charAt(0) == '+') {
                    ++n;
                }
                if (string.startsWith("0x", n)) {
                    BigInteger bigInteger = new BigInteger(string.substring(n + 2), 16);
                    return var5_109;
                } else {
                    BigInteger bigInteger = new BigInteger(string.substring(n));
                }
            }
            return var5_109;
        } else if (BigDecimal.class.equals(clazz) || Number.class.equals(clazz)) {
            String string = object2.toString().trim();
            if (string.length() <= 0) return var5_109;
            if (string.charAt(0) == '+') {
                BigDecimal bigDecimal = new BigDecimal(string.substring(1));
                return var5_109;
            } else {
                BigDecimal bigDecimal = new BigDecimal(string);
            }
            return var5_109;
        } else if (Character.TYPE.equals(clazz) || Character.class.equals(clazz)) {
            if (object2 instanceof Boolean) {
                Character c = Character.valueOf((Boolean)object2 != false ? (char)'1' : '0');
                return var5_109;
            } else if (object2 instanceof Number) {
                Character c = Character.valueOf((char)((Number)object2).intValue());
                return var5_109;
            } else {
                String string = object2.toString();
                if (string.length() > 0) {
                    Character c = Character.valueOf(string.charAt(0));
                    return var5_109;
                } else {
                    if (!clazz.isPrimitive()) return var5_109;
                    Character c = Character.valueOf('\u0000');
                }
            }
            return var5_109;
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            String string = object2.toString();
            return var5_109;
        } else if (Appendable.class.isAssignableFrom(clazz)) {
            Appendable appendable = (Appendable)this.create(clazz);
            Appendable appendable2 = appendable.append(object2.toString());
            return var5_109;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            if (object2 instanceof Number) {
                T t = clazz.getEnumConstants()[((Number)object2).intValue()];
                return var5_109;
            } else {
                T t = Enum.valueOf(clazz, object2.toString().trim());
            }
            return var5_109;
        } else if (Pattern.class.equals(clazz)) {
            Pattern pattern = Pattern.compile(object2.toString());
            return var5_109;
        } else if (Date.class.isAssignableFrom(clazz)) {
            if (object2 instanceof Number) {
                Date date = (Date)this.create(clazz);
                date.setTime(((Number)object2).longValue());
                Date date2 = date;
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() <= 0) return var5_109;
                Date date = (Date)this.create(clazz);
                date.setTime(this.convertDate(string));
                Date date3 = date;
            }
            return var5_109;
        } else if (Calendar.class.isAssignableFrom(clazz)) {
            if (object2 instanceof Number) {
                Calendar calendar = (Calendar)this.create(clazz);
                calendar.setTimeInMillis(((Number)object2).longValue());
                Calendar calendar2 = calendar;
                return var5_109;
            } else {
                String string = object2.toString().trim();
                if (string.length() <= 0) return var5_109;
                Calendar calendar = (Calendar)this.create(clazz);
                calendar.setTimeInMillis(this.convertDate(string));
                Calendar calendar3 = calendar;
            }
            return var5_109;
        } else if (TimeZone.class.equals(clazz)) {
            TimeZone timeZone = TimeZone.getTimeZone(object2.toString().trim());
            return var5_109;
        } else if (Locale.class.equals(clazz)) {
            String[] stringArray = object2.toString().split("\\p{Punct}");
            if (stringArray.length == 1) {
                Locale locale = new Locale(stringArray[0]);
                return var5_109;
            } else if (stringArray.length == 2) {
                Locale locale = new Locale(stringArray[0], stringArray[1]);
                return var5_109;
            } else {
                if (stringArray.length <= 2) return var5_109;
                Locale locale = new Locale(stringArray[0], stringArray[1], stringArray[2]);
            }
            return var5_109;
        } else if (URL.class.equals(clazz)) {
            URL uRL = new URL(object2.toString().trim());
            return var5_109;
        } else if (URI.class.equals(clazz)) {
            URI uRI = new URI(object2.toString().trim());
            return var5_109;
        } else if (InetAddress.class.equals(clazz)) {
            InetAddress inetAddress = InetAddress.getByName(object2.toString().trim());
            return var5_109;
        } else if (Charset.class.equals(clazz)) {
            Charset charset = Charset.forName(object2.toString().trim());
            return var5_109;
        } else if (Class.class.equals(clazz)) {
            String string = object2.toString().trim();
            if (string.equals("boolean")) {
                Class<Boolean> clazz13 = Boolean.TYPE;
                return var5_109;
            } else if (string.equals("byte")) {
                Class<Byte> clazz14 = Byte.TYPE;
                return var5_109;
            } else if (string.equals("short")) {
                Class<Short> clazz15 = Short.TYPE;
                return var5_109;
            } else if (string.equals("int")) {
                Class<Integer> clazz16 = Integer.TYPE;
                return var5_109;
            } else if (string.equals("long")) {
                Class<Long> clazz17 = Long.TYPE;
                return var5_109;
            } else if (string.equals("float")) {
                Class<Float> clazz18 = Float.TYPE;
                return var5_109;
            } else if (string.equals("double")) {
                Class<Double> clazz19 = Double.TYPE;
                return var5_109;
            } else {
                Class<?> clazz20 = Class.forName(object2.toString());
            }
            return var5_109;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)this.create(clazz);
            if (type instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
                Class<Object> clazz21 = typeArray != null && typeArray.length > 0 ? typeArray[0] : Object.class;
                Class<?> clazz22 = JSON.getRawType(clazz21);
                collection.add(this.convertChild(0, object2, (Class<? extends T>)clazz22, (Type)((Object)clazz21)));
            } else {
                collection.add(object2);
            }
            Collection collection3 = collection;
            return var5_109;
        } else {
            if (!clazz.isArray()) throw new UnsupportedOperationException();
            if (object2 instanceof String && Byte.TYPE.equals(clazz.getComponentType())) {
                byte[] byArray = Base64.decode((String)object2);
                return var5_109;
            } else {
                Object object10 = Array.newInstance(clazz.getComponentType(), 1);
                Class<?> clazz23 = clazz.getComponentType();
                Class<?> clazz24 = type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : clazz23;
                Array.set(object10, 0, this.convertChild(0, object2, clazz23, clazz24));
                Object object11 = object10;
            }
        }
        return var5_109;
    }

    protected boolean ignore(Class<?> clazz, Member member) {
        int n = member.getModifiers();
        if (Modifier.isStatic(n)) {
            return true;
        }
        if (Modifier.isTransient(n)) {
            return true;
        }
        return member.getDeclaringClass().equals(Object.class);
    }

    protected Object create(Class<?> clazz) throws Exception {
        Serializable serializable = null;
        if (clazz.isInterface()) {
            if (SortedMap.class.equals(clazz)) {
                serializable = new TreeMap();
            } else if (Map.class.equals(clazz)) {
                serializable = new LinkedHashMap();
            } else if (SortedSet.class.equals(clazz)) {
                serializable = new TreeSet();
            } else if (Set.class.equals(clazz)) {
                serializable = new LinkedHashSet();
            } else if (List.class.equals(clazz)) {
                serializable = new ArrayList();
            } else if (Collection.class.equals(clazz)) {
                serializable = new ArrayList();
            } else if (Appendable.class.equals(clazz)) {
                serializable = new StringBuilder();
            }
        } else if (Modifier.isAbstract(clazz.getModifiers())) {
            if (Calendar.class.equals(clazz)) {
                serializable = Calendar.getInstance();
            }
        } else if (clazz.isMemberClass() || clazz.isAnonymousClass()) {
            Class<?> clazz2 = clazz.getEnclosingClass();
            Constructor<?> constructor = clazz.getDeclaredConstructor(clazz2);
            if (this.tryAccess(clazz)) {
                constructor.setAccessible(true);
            }
            serializable = this.context != null && clazz2.isAssignableFrom(this.context.getClass()) ? constructor.newInstance(this.context) : constructor.newInstance(new Object[]{null});
        } else {
            Constructor<?> constructor;
            if (Date.class.isAssignableFrom(clazz)) {
                try {
                    constructor = clazz.getDeclaredConstructor(Long.TYPE);
                    if (this.tryAccess(clazz)) {
                        constructor.setAccessible(true);
                    }
                    serializable = constructor.newInstance(0L);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (serializable == null) {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                if (this.tryAccess(clazz)) {
                    constructor.setAccessible(true);
                }
                serializable = constructor.newInstance(new Object[0]);
            }
        }
        return serializable;
    }

    private Member mapping(Class clazz, Map<String, Member> map, String string) {
        Member member = map.get(string);
        if (member == null && (member = map.get(JSON.toLowerCamel(string))) == null) {
            member = map.get(string + "_");
        }
        return member;
    }

    private boolean tryAccess(Class<?> clazz) {
        int n = clazz.getModifiers();
        if (this.scope != null && !Modifier.isPublic(n)) {
            if (Modifier.isPrivate(n)) {
                return this.scope.equals(clazz.getEnclosingClass());
            }
            return clazz.getPackage().equals(this.scope.getPackage());
        }
        return false;
    }

    private static String toLowerCamel(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 1 && Character.isUpperCase(stringBuilder.charAt(0)) && Character.isLowerCase(stringBuilder.charAt(1))) {
            stringBuilder.setCharAt(0, Character.toLowerCase(stringBuilder.charAt(0)));
        }
        return stringBuilder.toString();
    }

    private Map<String, Member> getGetProperties(Class<?> clazz) {
        HashMap<String, Member> hashMap = new HashMap<String, Member>();
        boolean bl = this.tryAccess(clazz);
        for (Field accessibleObject : clazz.getFields()) {
            if (this.ignore(clazz, accessibleObject)) continue;
            if (bl) {
                accessibleObject.setAccessible(true);
            }
            hashMap.put(accessibleObject.getName(), accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (this.ignore(clazz, (Member)((Object)accessibleObject))) continue;
            String string = ((Method)accessibleObject).getName();
            int n = 0;
            if (string.startsWith("get") && string.length() > 3 && Character.isUpperCase(string.charAt(3)) && ((Method)accessibleObject).getParameterTypes().length == 0 && !((Method)accessibleObject).getReturnType().equals(Void.TYPE)) {
                n = 3;
            } else {
                if (!string.startsWith("is") || string.length() <= 2 || !Character.isUpperCase(string.charAt(2)) || ((Method)accessibleObject).getParameterTypes().length != 0 || !((Method)accessibleObject).getReturnType().equals(Boolean.TYPE)) continue;
                n = 2;
            }
            char[] cArray = string.toCharArray();
            if (cArray.length < n + 2 || Character.isLowerCase(cArray[n + 1])) {
                cArray[n] = Character.toLowerCase(cArray[n]);
            }
            if (bl) {
                ((Method)accessibleObject).setAccessible(true);
            }
            hashMap.put(new String(cArray, n, cArray.length - n), (Member)((Object)accessibleObject));
        }
        return hashMap;
    }

    private Map<String, Member> getSetProperties(Class<?> clazz) {
        HashMap<String, Member> hashMap = new HashMap<String, Member>();
        boolean bl = this.tryAccess(clazz);
        for (Field accessibleObject : clazz.getFields()) {
            if (this.ignore(clazz, accessibleObject)) continue;
            if (bl) {
                accessibleObject.setAccessible(true);
            }
            hashMap.put(accessibleObject.getName(), accessibleObject);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (this.ignore(clazz, (Member)((Object)accessibleObject))) continue;
            String string = ((Method)accessibleObject).getName();
            int n = 0;
            if (!string.startsWith("set") || string.length() <= 3 || !Character.isUpperCase(string.charAt(3)) || ((Method)accessibleObject).getParameterTypes().length != 1 || !((Method)accessibleObject).getReturnType().equals(Void.TYPE)) continue;
            n = 3;
            char[] cArray = string.toCharArray();
            if (cArray.length < n + 2 || Character.isLowerCase(cArray[n + 1])) {
                cArray[n] = Character.toLowerCase(cArray[n]);
            }
            if (bl) {
                ((Method)accessibleObject).setAccessible(true);
            }
            hashMap.put(new String(cArray, n, cArray.length - n), (Member)((Object)accessibleObject));
        }
        return hashMap;
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Class<?> clazz = null;
            try {
                clazz = Array.newInstance(JSON.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return clazz;
        }
        if (type instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            return typeArray.length > 0 ? JSON.getRawType(typeArray[0]) : Object.class;
        }
        return Object.class;
    }

    private Long convertDate(String string) throws ParseException {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        string = Pattern.compile("(?:GMT|UTC)([+-][0-9]{2})([0-9]{2})").matcher(string).replaceFirst("GMT$1:$2");
        DateFormat dateFormat = null;
        if (Character.isDigit(string.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            String string2 = "yMdHmsSZ";
            int n = string.length() > 2 && string.charAt(2) == ':' ? 3 : 0;
            boolean bl = true;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                boolean bl2;
                char c = string.charAt(i);
                if (!(n != 4 && n != 5 && n != 6 || c != '+' && c != '-' || i + 1 >= string.length() || !Character.isDigit(string.charAt(i + 1)))) {
                    if (!bl) {
                        stringBuilder.append('\'');
                    }
                    n = 7;
                    n2 = 0;
                    bl = true;
                    continue;
                }
                if (n == 7 && c == ':' && i + 1 < string.length() && Character.isDigit(string.charAt(i + 1))) {
                    string = string.substring(0, i) + string.substring(i + 1);
                    continue;
                }
                boolean bl3 = bl2 = Character.isDigit(c) && n < 8;
                if (bl != bl2) {
                    stringBuilder.append('\'');
                    if (bl2) {
                        n2 = 0;
                        ++n;
                    }
                }
                if (bl2) {
                    char c2 = string2.charAt(n);
                    if (n2 == (c2 == 'y' || c2 == 'Z' ? 4 : (c2 == 'S' ? 3 : 2))) {
                        n2 = 0;
                        c2 = string2.charAt(++n);
                    }
                    if (c2 != 'Z' || n2 == 0) {
                        stringBuilder.append(c2);
                    }
                    ++n2;
                } else {
                    stringBuilder.append(c == '\'' ? "''" : Character.valueOf(c));
                }
                bl = bl2;
            }
            if (!bl) {
                stringBuilder.append('\'');
            }
            dateFormat = new SimpleDateFormat(stringBuilder.toString(), Locale.ENGLISH);
        } else if (string.length() > 18) {
            if (string.charAt(3) == ',') {
                String string3 = "EEE, dd MMM yyyy HH:mm:ss Z";
                dateFormat = new SimpleDateFormat(string.length() < string3.length() ? string3.substring(0, string.length()) : string3, Locale.ENGLISH);
            } else if (string.charAt(13) == ':') {
                dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH);
            } else if (string.charAt(18) == ':') {
                String string4 = "EEE MMM dd yyyy HH:mm:ss Z";
                dateFormat = new SimpleDateFormat(string.length() < string4.length() ? string4.substring(0, string.length()) : string4, Locale.ENGLISH);
            } else {
                dateFormat = DateFormat.getDateTimeInstance(2, 2, this.locale);
            }
        } else {
            dateFormat = DateFormat.getDateInstance(2, this.locale);
        }
        return dateFormat.parse(string).getTime();
    }

    static {
        PRIMITIVE_MAP.put(Boolean.TYPE, false);
        PRIMITIVE_MAP.put(Byte.TYPE, (byte)0);
        PRIMITIVE_MAP.put(Short.TYPE, (short)0);
        PRIMITIVE_MAP.put(Integer.TYPE, 0);
        PRIMITIVE_MAP.put(Long.TYPE, 0L);
        PRIMITIVE_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        PRIMITIVE_MAP.put(Double.TYPE, 0.0);
        PRIMITIVE_MAP.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

