/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.arnx.jsonic.JSON;

public class GatewayFilter
implements Filter {
    public static final String GATEWAY_KEY = Config.class.getName();
    private Map<Pattern, Config> locations = new LinkedHashMap<Pattern, Config>();
    private ServletContext context;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        JSON jSON = new JSON();
        jSON.setContext(this);
        String string = filterConfig.getInitParameter("config");
        if (string == null) {
            string = "";
        }
        Map map = jSON.parse((CharSequence)string, Map.class);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Field field : Config.class.getFields()) {
            linkedHashMap.put(field.getName(), map.get(field.getName()));
        }
        Config config = (Config)jSON.convert(linkedHashMap, (Type)((Object)Config.class));
        for (Map.Entry entry : map.entrySet()) {
            if (linkedHashMap.containsKey(entry.getKey()) || !(entry.getValue() instanceof Map)) continue;
            Map map2 = (Map)entry.getValue();
            for (Map.Entry entry2 : linkedHashMap.entrySet()) {
                if (map2.get(entry2.getKey()) != null) continue;
                map2.put(entry2.getKey(), entry2.getValue());
            }
            Config config2 = (Config)jSON.convert(map2, (Type)((Object)Config.class));
            this.locations.put(Pattern.compile("^" + entry.getKey() + "$"), config2);
        }
        this.locations.put(Pattern.compile(".*"), config);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse object, FilterChain filterChain) throws IOException, ServletException {
        Object object2;
        Map.Entry<Pattern, Config> entry22;
        if (httpServletRequest.getAttribute(GATEWAY_KEY) != null) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)object);
        }
        String string = httpServletRequest.getContextPath().equals("/") ? httpServletRequest.getRequestURI() : httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length());
        Matcher matcher = null;
        Config config = null;
        for (Map.Entry<Pattern, Config> entry22 : this.locations.entrySet()) {
            object2 = entry22.getKey();
            Matcher object3 = ((Pattern)object2).matcher(string);
            if (!object3.matches()) continue;
            matcher = object3;
            config = entry22.getValue();
            break;
        }
        Object object4 = null;
        if (config.access != null) {
            boolean bl = false;
            for (String string2 : config.access) {
                if (!httpServletRequest.isUserInRole(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                object.sendError(403, "Forbidden");
                return;
            }
        }
        if (config.encoding != null) {
            httpServletRequest.setCharacterEncoding(config.encoding);
            object.setCharacterEncoding(config.encoding);
        }
        if (config.locale != null) {
            object.setLocale(config.locale);
        }
        if (config.expire != null && config.expire.booleanValue()) {
            object.setHeader("Cache-Control", "no-cache");
            object.setHeader("Pragma", "no-cache");
            object.setHeader("Expires", "Tue, 29 Feb 2000 12:00:00 GMT");
        }
        if (config.compression != null && config.compression.booleanValue()) {
            entry22 = httpServletRequest.getHeaders("Accept-Encoding");
            while (entry22.hasMoreElements()) {
                object2 = (String)entry22.nextElement();
                if (((String)object2).indexOf("gzip") == -1) continue;
                object.setHeader("Content-Encoding", ((String)object2).indexOf("x-gzip") != -1 ? "x-gzip" : "gzip");
                object = new GZIPResponse((HttpServletResponse)object);
                break;
            }
        }
        if (config.forward != null) {
            try {
                object4 = new URI(matcher.replaceAll(config.forward));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ServletException((Throwable)uRISyntaxException);
            }
        }
        httpServletRequest.setAttribute(GATEWAY_KEY, (Object)config);
        if (object4 != null) {
            entry22 = this.context.getRequestDispatcher(((URI)object4).toString());
            entry22.forward((ServletRequest)httpServletRequest, (ServletResponse)object);
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)object);
        }
        if (object instanceof GZIPResponse) {
            ((GZIPResponse)((Object)object)).close();
        }
    }

    public void destroy() {
        this.locations = null;
    }

    class GZIPResponse
    extends HttpServletResponseWrapper {
        private ServletOutputStream out;
        private PrintWriter writer;

        public GZIPResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
            this.out = null;
            this.writer = null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.out == null) {
                this.out = new ServletOutputStream(){
                    private GZIPOutputStream cout;
                    {
                        this.cout = new GZIPOutputStream((OutputStream)GZIPResponse.super.getOutputStream());
                    }

                    public void write(byte[] byArray, int n, int n2) throws IOException {
                        this.cout.write(byArray, n, n2);
                    }

                    public void write(byte[] byArray) throws IOException {
                        this.cout.write(byArray);
                    }

                    public void write(int n) throws IOException {
                        this.cout.write(n);
                    }

                    public void flush() throws IOException {
                        this.cout.flush();
                    }

                    public void close() throws IOException {
                        this.cout.close();
                    }
                };
            }
            return this.out;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.writer;
        }

        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            } else if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
    }

    class Config {
        public String encoding = null;
        public Boolean compression = false;
        public Boolean expire = false;
        public String forward = null;
        public Set<String> access = null;
        public Locale locale = null;

        Config() {
        }
    }
}

