/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class BooleanConstantNode
extends ConstantNode {
    boolean booleanValue;
    boolean unknownValue;

    public void init(Object object) throws StandardException {
        if (object instanceof Boolean) {
            super.init(TypeId.BOOLEAN_ID, Boolean.FALSE, ReuseFactory.getInteger(1));
            this.booleanValue = (Boolean)object;
            super.setValue(this.getDataValueFactory().getDataValue(this.booleanValue));
        } else {
            super.init(object, Boolean.TRUE, ReuseFactory.getInteger(0));
            this.unknownValue = true;
        }
    }

    Object getConstantValueAsObject() {
        return this.booleanValue ? Boolean.TRUE : Boolean.FALSE;
    }

    String getValueAsString() {
        if (this.booleanValue) {
            return "true";
        }
        return "false";
    }

    boolean isBooleanTrue() {
        return this.booleanValue && !this.unknownValue;
    }

    boolean isBooleanFalse() {
        return !this.booleanValue && !this.unknownValue;
    }

    public double selectivity(Optimizable optimizable) {
        if (this.isBooleanTrue()) {
            return 1.0;
        }
        return 0.0;
    }

    ValueNode eliminateNots(boolean bl) {
        if (!bl) {
            return this;
        }
        this.booleanValue = !this.booleanValue;
        super.setValue(this.getDataValueFactory().getDataValue(this.booleanValue));
        return this;
    }

    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) {
        methodBuilder.push(this.booleanValue);
    }

    public void setValue(DataValueDescriptor dataValueDescriptor) {
        super.setValue(dataValueDescriptor);
        this.unknownValue = true;
        try {
            if (dataValueDescriptor != null && dataValueDescriptor.isNotNull().getBoolean()) {
                this.booleanValue = dataValueDescriptor.getBoolean();
                this.unknownValue = false;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }
}

