/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.dao;

import java.io.Serializable;
import java.util.List;

/**
 * Java SE 5 から導入された型総称性 (JSR-14 Generics) を利用した
 * 汎用的な DAO のインタフェースです。
 * 
 * @param <T>
 *            エンティティのクラス
 * @param <ID>
 *            主キーのクラス
 */
public interface GenericDAO<T, ID extends Serializable> {

	/**
	 * エンティティの新しいインスタンスを永続化します。
	 * 
	 * @param newInstance
	 *            永続化するインスタンス
	 * @return 永続化されたインスタンス
	 */
	T create(T newInstance);

	/**
	 * 主キーで指定されたエンティティのインスタンスを取得します。
	 * 
	 * @param id
	 *            インスタンスを一意に識別するための主キー
	 * @return 主キーの値に対応するインスタンス
	 */
	T find(ID id);

	/**
	 * エンティティのすべてのインスタンスを取得します。
	 * 
	 * @return すべてのインスタンス
	 */
	List<T> findAll();

	/**
	 * エンティティのインスタンスを指定した値で更新します。
	 * 
	 * @param transientObject
	 *            更新対象のインスタンス
	 */
	void update(T transientObject);

	/**
	 * 指定したインスタンスを削除します。
	 * 
	 * @param persistentObject
	 *            削除対象のインスタンス
	 */
	void delete(T persistentObject);

}
