/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.calculation.controller;

import java.io.InputStream;

import javax.xml.bind.JAXBContext;

import jp.sf.maskat.sample.calculation.dto.CalculationRequest;
import jp.sf.maskat.sample.calculation.dto.CalculationResponse;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 四則演算アプリケーションから送信されるリモートイベントを処理する
 * ためのコントローラです。
 */
@Controller
public class CalculationController {

	@RequestMapping("/sample/calculation/calculate.do")
	public String calculate(InputStream stream, ModelMap model)
			throws Exception {
		/* 要求メッセージを bean に読み込む */
		JAXBContext context = JAXBContext.newInstance(CalculationRequest.class);
		CalculationRequest command = (CalculationRequest) context
				.createUnmarshaller().unmarshal(stream);

		/* 四則演算を実行する */
		int left = command.getLeftOperand();
		int right = command.getRightOperand();
		String operator = command.getOperator();

		int value = 0;
		if ("+".equals(operator)) {
			value = left + right;
		} else if ("-".equals(operator)) {
			value = left - right;
		} else if ("*".equals(operator)) {
			value = left * right;
		} else if ("/".equals(operator)) {
			value = left / right;
		}

		/* 応答メッセージ出力の bean を設定する */
		model.addAttribute(new CalculationResponse(value));
		return "calculationResponse";
	}

}
