/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.controller;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;

import jp.sf.maskat.sample.fruitshop.dto.ListOrderRequest;
import jp.sf.maskat.sample.fruitshop.dto.RegisterCustomerRequest;
import jp.sf.maskat.sample.fruitshop.dto.RegisterOrderRequest;
import jp.sf.maskat.sample.fruitshop.dto.SearchCustomerRequest;
import jp.sf.maskat.sample.fruitshop.dto.SearchProductRequest;
import jp.sf.maskat.sample.fruitshop.service.FruitShopCustomerService;
import jp.sf.maskat.sample.fruitshop.service.FruitShopOrderService;
import net.arnx.jsonic.JSON;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * フルーツショップアプリケーションから送信されるリモートイベントを
 * 処理するためのコントローラです。
 */
@Controller
public class FruitShopController {

	private FruitShopCustomerService customerService;

	private FruitShopOrderService orderService;

	@Resource
	public void setCustomerService(FruitShopCustomerService customerService) {
		this.customerService = customerService;
	}

	@Resource
	public void setOrderService(FruitShopOrderService orderService) {
		this.orderService = orderService;
	}

	@RequestMapping("/sample/fruitshop/codelib.do")
	public String codelib(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		/* コード／ラベル対応表を取得 */
		List<Object[]> codes = null;
		String keyword = null;
		if ((keyword = request.getParameter("customerIdText")) != null) {
			codes = orderService.getCustomerCodes(keyword);
		} else if ((keyword = request.getParameter("productIdText")) != null) {
			codes = orderService.getProductCodes(keyword);
		}

		/* JSON 形式で応答メッセージに出力 */
		response.setContentType("text/json; charset=UTF-8");
		PrintWriter writer = response.getWriter();
		writer.write(codes != null ? JSON.encode(codes) : "");
		writer.close();

		return null;
	}

	@RequestMapping("/sample/fruitshop/search_customer.do")
	public String searchCustomer(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(SearchCustomerRequest.class);
		SearchCustomerRequest command = (SearchCustomerRequest) context
				.createUnmarshaller().unmarshal(stream);

		model.addAttribute(customerService.searchCustomer(command));
		return "searchCustomerResponse";
	}

	@RequestMapping("/sample/fruitshop/search_product.do")
	public String searchProduct(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(SearchProductRequest.class);
		SearchProductRequest command = (SearchProductRequest) context
				.createUnmarshaller().unmarshal(stream);

		model.addAttribute(orderService.searchProduct(command));
		return "searchProductResponse";
	}

	@RequestMapping("/sample/fruitshop/register_customer.do")
	public String registerCustomer(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(RegisterCustomerRequest.class);
		RegisterCustomerRequest command = (RegisterCustomerRequest) context
				.createUnmarshaller().unmarshal(stream);

		model.addAttribute(customerService.registerCustomer(command));
		return "registerCustomerResponse";
	}

	@RequestMapping("/sample/fruitshop/register_order.do")
	public String registerOrder(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext
				.newInstance(RegisterOrderRequest.class);
		RegisterOrderRequest command = (RegisterOrderRequest) context
				.createUnmarshaller().unmarshal(stream);

		model.addAttribute(orderService.registerOrder(command));
		return "registerOrderResponse";
	}

	@RequestMapping("/sample/fruitshop/list_orders.do")
	public String listOrder(InputStream stream, ModelMap model)
			throws Exception {
		JAXBContext context = JAXBContext.newInstance(ListOrderRequest.class);
		ListOrderRequest command = (ListOrderRequest) context
				.createUnmarshaller().unmarshal(stream);

		model.addAttribute(orderService.listOrders(command));
		return "listOrderResponse";
	}

}
