/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.dao;

import java.text.DecimalFormat;
import java.text.Format;

import jp.sf.maskat.dao.GenericDAOJpaImpl;
import jp.sf.maskat.sample.fruitshop.entity.FruitShopCustomer;

import org.springframework.stereotype.Repository;

/**
 * JPA を使用した {@link FruitShopCustomerDAO} の実装です。
 */
@Repository
public class FruitShopCustomerDAOJpaImpl extends
		GenericDAOJpaImpl<FruitShopCustomer, String> implements
		FruitShopCustomerDAO {

	/** 顧客コードのシーケンス */
	private int customerIdSeq;

	/** 顧客コードのフォーマット */
	private Format customerIdFormat;

	public FruitShopCustomerDAOJpaImpl() {
		super(FruitShopCustomer.class);
		customerIdFormat = new DecimalFormat("0000");
	}

	/**
	 * 新しい顧客コードを生成して返します。
	 * 
	 * @return 新しい顧客コード
	 */
	private synchronized String generateCustomerCode() {
		if (customerIdSeq == 0) {
			customerIdSeq = findAll().size();
		}
		return customerIdFormat.format(++customerIdSeq);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.dao.GenericDAOJpaImpl#create(java.lang.Object)
	 */
	@Override
	public FruitShopCustomer create(FruitShopCustomer newInstance) {
		newInstance.setCustomerId(generateCustomerCode());
		return super.create(newInstance);
	}

}
