/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.dto;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import jp.sf.maskat.sample.fruitshop.entity.FruitShopOrder;

import org.springframework.beans.BeanUtils;

@XmlRootElement(name = "response")
@XmlAccessorType(XmlAccessType.FIELD)
public class ListOrderResponse {

	@XmlElementWrapper(name = "orders")
	@XmlElement(name = "order")
	private List<Order> orders;

	public List<Order> getOrders() {
		return orders;
	}

	public void setOrders(List<FruitShopOrder> orders) {
		this.orders = new ArrayList<Order>();

		for (FruitShopOrder order : orders) {
			Order dto = new Order(order);
			this.orders.add(dto);
		}
	}

	@XmlAccessorType(XmlAccessType.FIELD)
	public static class Order {

		private String orderId;

		private String customerId;

		private String customerName;

		@XmlJavaTypeAdapter(DateAdapter.class)
		private Date orderDate;

		@XmlElement(name = "totalAmount")
		private int total;

		public Order() {
			super();
		}

		public Order(FruitShopOrder order) {
			super();
			BeanUtils.copyProperties(order, this);
			setCustomerName(order.getCustomer().getName());
		}

		public String getOrderId() {
			return orderId;
		}

		public void setOrderId(String orderId) {
			this.orderId = orderId;
		}

		public String getCustomerId() {
			return customerId;
		}

		public void setCustomerId(String customerId) {
			this.customerId = customerId;
		}

		public String getCustomerName() {
			return customerName;
		}

		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}

		public Date getOrderDate() {
			return orderDate;
		}

		public void setOrderDate(Date orderDate) {
			this.orderDate = orderDate;
		}

		public int getTotal() {
			return total;
		}

		public void setTotal(int total) {
			this.total = total;
		}
	}

	/**
	 * XML 文書で使用する日付をスラッシュ ('/') 区切りで入出力するための
	 * 変換アダプタです。
	 */
	public static class DateAdapter extends XmlAdapter<String, Date> {

		/** XML 文書で使用する日付のフォーマット */
		private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
		 */
		@Override
		public String marshal(Date v) throws Exception {
			return dateFormat.format(v);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see javax.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
		 */
		@Override
		public Date unmarshal(String v) throws Exception {
			return dateFormat.parse(v);
		}
	}

}
