/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.entity;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * フルーツショップの受注明細情報を表すエンティティです。
 */
@Entity
@Table(name = "fruitshop_order_details")
@IdClass(FruitShopOrderDetail.FruitShopOrderDetailId.class)
public class FruitShopOrderDetail {

	/** 受注コード */
	@Id
	@Column(name = "order_id")
	private String orderId;

	/** この受注明細情報を含んでいる受注情報 */
	@ManyToOne
	@JoinColumn(name = "order_id")
	private FruitShopOrder order;

	/** 商品コード */
	@Id
	@Column(name = "product_id")
	private String productId;

	/** 商品情報 */
	@ManyToOne
	@JoinColumn(name = "product_id")
	private FruitShopProduct product;

	/** 数量 */
	private int quantity;

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public FruitShopOrder getOrder() {
		return order;
	}

	public void setOrder(FruitShopOrder order) {
		this.order = order;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public FruitShopProduct getProduct() {
		return product;
	}

	public void setProduct(FruitShopProduct product) {
		this.product = product;
	}

	public int getQuantity() {
		return quantity;
	}

	public void setQuantity(int quantity) {
		this.quantity = quantity;
	}

	public static class FruitShopOrderDetailId implements Serializable {

		private static final long serialVersionUID = -4792112527196788615L;

		private String orderId;

		private String productId;

		public String getOrderId() {
			return orderId;
		}

		public void setOrderId(String orderId) {
			this.orderId = orderId;
		}

		public String getProductId() {
			return productId;
		}

		public void setProductId(String productId) {
			this.productId = productId;
		}

		@Override
		public boolean equals(Object obj) {
			return (obj instanceof FruitShopOrderDetailId)
					&& equals((FruitShopOrderDetailId) obj);
		}

		public boolean equals(FruitShopOrderDetailId another) {
			return orderId != null && productId != null
					&& orderId.equals(another.getOrderId())
					&& productId.equals(another.getProductId());
		}

		@Override
		public int hashCode() {
			return orderId.concat(productId).hashCode();
		}

	}

}
