/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.service;

import javax.annotation.Resource;

import jp.sf.maskat.sample.fruitshop.dao.FruitShopCustomerDAO;
import jp.sf.maskat.sample.fruitshop.dto.RegisterCustomerRequest;
import jp.sf.maskat.sample.fruitshop.dto.RegisterCustomerResponse;
import jp.sf.maskat.sample.fruitshop.dto.SearchCustomerRequest;
import jp.sf.maskat.sample.fruitshop.dto.SearchCustomerResponse;
import jp.sf.maskat.sample.fruitshop.entity.FruitShopCustomer;

import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * POJO を用いた {@link FruitShopCustomerService} の実装です。
 */
@Service
@Transactional
public class FruitShopCustomerServiceImpl implements FruitShopCustomerService {

	/** 顧客情報を管理する DAO */
	private FruitShopCustomerDAO customerDAO;

	/**
	 * 顧客情報を管理する DAO を設定します。
	 * 
	 * @param customerDAO
	 *            顧客情報を管理する DAO
	 */
	@Resource
	public void setCustomerDAO(FruitShopCustomerDAO customerDAO) {
		this.customerDAO = customerDAO;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.sample.fruitshop.service.FruitShopCustomerService#registerCustomer(jp.sf.maskat.sample.fruitshop.dto.RegisterCustomerRequest)
	 */
	public RegisterCustomerResponse registerCustomer(
			RegisterCustomerRequest request) {
		FruitShopCustomer customer = new FruitShopCustomer();
		BeanUtils.copyProperties(request, customer);
		customer = customerDAO.create(customer);

		return new RegisterCustomerResponse(customer.getCustomerId());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.sample.fruitshop.service.FruitShopCustomerService#searchCustomer(jp.sf.maskat.sample.fruitshop.dto.SearchCustomerRequest)
	 */
	public SearchCustomerResponse searchCustomer(SearchCustomerRequest request) {
		FruitShopCustomer customer = customerDAO.find(request.getCustomerId());

		SearchCustomerResponse result = new SearchCustomerResponse();
		BeanUtils.copyProperties(customer, result);

		return result;
	}

}
