/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.fruitshop.service;

import java.util.List;

import jp.sf.maskat.sample.fruitshop.dto.ListOrderRequest;
import jp.sf.maskat.sample.fruitshop.dto.ListOrderResponse;
import jp.sf.maskat.sample.fruitshop.dto.RegisterOrderRequest;
import jp.sf.maskat.sample.fruitshop.dto.RegisterOrderResponse;
import jp.sf.maskat.sample.fruitshop.dto.SearchProductRequest;
import jp.sf.maskat.sample.fruitshop.dto.SearchProductResponse;

/**
 * 受注業務に関する業務ロジックを提供するサービスです。
 */
public interface FruitShopOrderService {

	List<Object[]> getCustomerCodes(String keyword);

	List<Object[]> getProductCodes(String keyword);

	SearchProductResponse searchProduct(SearchProductRequest request);

	ListOrderResponse listOrders(ListOrderRequest request);

	RegisterOrderResponse registerOrder(RegisterOrderRequest request);

}
