/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.gourmet.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sf.maskat.dao.GenericDAOJpaImpl;
import jp.sf.maskat.sample.gourmet.entity.GourmetRestaurant;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

/**
 * JPA を使用した {@link GourmetRestaurantDAO} の実装です。
 */
@Repository
public class GourmetRestaurantDAOJpaImpl extends
		GenericDAOJpaImpl<GourmetRestaurant, String> implements
		GourmetRestaurantDAO {

	public GourmetRestaurantDAOJpaImpl() {
		super(GourmetRestaurant.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.sf.maskat.sample.gourmet.dao.GourmetRestaurantDAO#find(java.lang.Boolean,
	 *      java.lang.Boolean, java.lang.Boolean, java.lang.Integer,
	 *      java.lang.Integer, java.lang.Boolean)
	 */
	@SuppressWarnings("unchecked")
	public List<GourmetRestaurant> find(Boolean western, Boolean japanese,
			Boolean chinese, Integer budgetLowerLimit,
			Integer budgetUpperLimit, Boolean withCoupon)
			throws DataAccessException {

		List<String> conditions = new ArrayList();
		Map<String, Object> params = new HashMap();

		/* 予算の上限値・下限値の範囲指定 (未指定の場合はすべて) */
		if (budgetLowerLimit != null) {
			conditions.add("r.budget >= :budgetLowerLimit");
			params.put("budgetLowerLimit", budgetLowerLimit);
		}
		if (budgetUpperLimit != null) {
			conditions.add("r.budget <= :budgetUpperLimit");
			params.put("budgetUpperLimit", budgetUpperLimit);
		}

		/* 和食・中華・洋食の指定 (未指定の場合はすべて) */
		List styles = new ArrayList();
		if (western != null && western) {
			styles.add(GourmetRestaurant.STYLE_WESTERN);
		}
		if (japanese != null && japanese) {
			styles.add(GourmetRestaurant.STYLE_JAPANESE);
		}
		if (chinese != null && chinese) {
			styles.add(GourmetRestaurant.STYLE_CHINESE);
		}
		if (!styles.isEmpty()) {
			conditions.add("r.style IN (:styles)");
			params.put("styles", styles);
		}

		/* クーポンのあり・なしを指定する */
		if (withCoupon != null && withCoupon) {
			conditions.add("r.coupon = true");
		}

		/* 検索結果を返却する */
		String query = "SELECT r FROM GourmetRestaurant r";
		if (!conditions.isEmpty()) {
			query += " WHERE "
					+ StringUtils.join(conditions.toArray(), " AND ");
		}
		return getJpaTemplate().findByNamedParams(query, params);
	}
}
