/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.gourmet.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * レストラン検索の対象となるレストラン情報を表すエンティティです。
 */
@Entity
@Table(name = "gourmet_restaurants")
public class GourmetRestaurant {

	/** 洋食を表す定数 */
	public static final int STYLE_WESTERN = 0;

	/** 和食を表す定数 */
	public static final int STYLE_JAPANESE = 1;

	/** 中華を表す定数 */
	public static final int STYLE_CHINESE = 2;
	
	/** レストランコード */
	@Id
	@Column(name = "restaurant_id")
	private String restaurantId;

	/** 店舗名 */
	private String name;

	/** 住所 */
	private String address;

	/** 料理スタイル (0:洋食／1:和食／2:中華) */
	private int style;

	/** 予算 */
	private int budget;

	/** クーポンの種類 (1:あり／0:なし) */
	private boolean coupon;

	/** 緯度 */
	private double latitude;

	/** 経度 */
	private double longitude;

	/** 店舗の詳細情報 */
	private String description;

	public String getRestaurantId() {
		return restaurantId;
	}

	public void setRestaurantId(String restaurantId) {
		this.restaurantId = restaurantId;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public int getStyle() {
		return style;
	}

	public void setStyle(int style) {
		this.style = style;
	}

	public int getBudget() {
		return budget;
	}

	public void setBudget(int budget) {
		this.budget = budget;
	}

	public boolean isCoupon() {
		return coupon;
	}

	public void setCoupon(boolean coupon) {
		this.coupon = coupon;
	}

	public double getLatitude() {
		return latitude;
	}

	public void setLatitude(double latitude) {
		this.latitude = latitude;
	}

	public double getLongitude() {
		return longitude;
	}

	public void setLongitude(double longitude) {
		this.longitude = longitude;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

}
