/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.maskat.sample.petstore.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * ペットストアの在庫情報を表すエンティティです。
 */
@Entity
@Table(name = "petstore_items")
@NamedQuery(name = "PetStoreItem.findAllByProductId", query = "SELECT i FROM PetStoreItem i WHERE i.productId = ?1")
public class PetStoreItem {

	/** 在庫コード */
	@Id
	@Column(name = "item_id")
	private String itemId;

	/** 商品コード */
	@Column(name = "product_id")
	private String productId;

	/** 商品概要 */
	private String description;

	/** 価格 */
	private int price;

	/** 商品画像の URL */
	@Column(name = "image_url")
	private String imageURL;

	/** 紹介文 */
	private String account;

	public String getItemId() {
		return itemId;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getPrice() {
		return price;
	}

	public void setPrice(int price) {
		this.price = price;
	}

	public String getImageURL() {
		return imageURL;
	}

	public void setImageURL(String imageURL) {
		this.imageURL = imageURL;
	}

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

}
