<?php
/*
 * Copyright (c)  2006-2008 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* 要求メッセージを解析し、パラメータ配列へ格納する */
require_once("../lib/maskat.php");
$param = parse_request_xml();
$store = read_csv_file("data/petstore_items.csv");

/* 応答メッセージを出力 */
header("Content-Type: text/xml;charset=UTF-8");
echo '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
?>
<response>
  <items>
<?php
foreach ($store as $item) {
  if ($item["product_id"] == $param["productId"]) {
?>
    <item>
      <itemId><?php echo $item["id"]; ?></itemId>
      <productId><?php echo $item["product_id"]; ?></productId>
      <description><?php echo $item["description"]; ?></description>
      <price><?php echo $item["price"] ?></price>
      <imageURL><?php echo $item["image_url"]; ?></imageURL>
      <account><?php echo $item["account"]; ?></account>
    </item>
<?php
  }
}
?>
  </items>
</response>
