/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui;

import java.io.IOException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MaskatProjectPropertyPage extends PropertyPage implements
		IWorkbenchPreferencePage {

	private MaskatNature nature;
	private MaskatFrameworkDialogArea frameworkArea;
	private LayoutEditorDialogArea layoutArea;
    
	public void init(IWorkbench workbench) {}

	protected Control createContents(Composite parent) {
		IProject project = (IProject) this.getElement().getAdapter(IProject.class);
		
        Composite composite = new Composite(parent, SWT.NULL);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());

        frameworkArea = new MaskatFrameworkDialogArea(project, composite, SWT.NONE) {
			public void setValid(boolean valid) {
				MaskatProjectPropertyPage.this.setValid(valid);
			}
			public void setErrorMessage(String newMessage) {
				MaskatProjectPropertyPage.this.setErrorMessage(newMessage);
			}
		};
		layoutArea = new LayoutEditorDialogArea(composite, SWT.NONE) {
			public void setValid(boolean valid) {
				MaskatProjectPropertyPage.this.setValid(valid);
			}
			public void setErrorMessage(String newMessage) {
				MaskatProjectPropertyPage.this.setErrorMessage(newMessage);
			}
		};
		
		initPage();
        setErrorMessage(null);
		setMessage(null);
        return composite;
	}
	
	private void initPage() {
		frameworkArea.setMaskatFWPath(getMaskatNature().getMaskatFrameworkPath());
		layoutArea.setGridSelection(getMaskatNature().getGridSelection());
		layoutArea.setSnapToGridSelection(getMaskatNature().getSnapToGridSelection());
		layoutArea.setSnapToObjectSelection(getMaskatNature().getSnapToGeometrySelection());
		layoutArea.setGridSize(getMaskatNature().getGridSize());
	}

	public boolean performOk() {
		MaskatNature nature = getMaskatNature();
		nature.setMaskatFrameworkPath(new Path(frameworkArea.getMaskatFWPath()));
		nature.setGridSelection(layoutArea.getGridSelection());
		nature.setSnapToGridSelection(layoutArea.getSnapToGridSelection());
		nature.setSnapToGeometrySelection(layoutArea.getSnapToObjectSelection());
		nature.setGridSize(layoutArea.getGridSize());
		try {
			nature.getPreferenceStore().save();
		} catch (IOException e) {
			return false;
		}
		return super.performOk();
	}

	protected void performDefaults() {
		frameworkArea.setMaskatFWPath(new Path(
				MaskatNature.FRAMEWORK_PATH_DEFAULT));
		layoutArea.setGridSelection(new Boolean(
				MaskatNature.GRID_SELECTION_DEFAULT).booleanValue());
		layoutArea.setSnapToGridSelection(new Boolean(
				MaskatNature.SNAPTOGRID_SELECTION_DEFAULT).booleanValue());
		layoutArea.setSnapToObjectSelection(new Boolean(
				MaskatNature.SNAPTOGEOMETRY_SELECTION_DEFAULT).booleanValue());
		layoutArea.setGridSize(new Integer(
				MaskatNature.GRID_SIZE_DEFAULT).intValue());
		super.performDefaults();
	}

	private MaskatNature getMaskatNature() {
		if (nature == null) {
			IProject project = (IProject) (getElement().getAdapter(IProject.class));
			nature = MaskatNature.getNature(project);
		}
		return nature;
	}
}
