/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties;

import jp.sf.maskat.core.layout.Layout;

import org.apache.commons.beanutils.DynaBean;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.views.properties.IPropertySource;


/**
 * ComponentDef->IPropertySouce
 */
public class PropertySourceAdapterFactory implements IAdapterFactory {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object,
	 *      java.lang.Class)
	 */
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType != IPropertySource.class) {
			return null;
		}
		
		if (adaptableObject instanceof DynaBean) {
			return new DynaBeanPropertySource((DynaBean) adaptableObject);
		}

		if (adaptableObject instanceof Layout) {
			return new LayoutPropertySource((Layout) adaptableObject);
		}
		return null;
	}

	public Class[] getAdapterList() {
		return new Class[] { IPropertySource.class };
	}

}
