/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;


public class ResultTreeNode extends AbstractTreeNode {
	
	private static final String ROOT_NODE_LABEL =
		Messages.getString("resultTreeNode.rootNodeLabel"); //$NON-NLS-1$		

	private static final String ADD_TARGET_NODE =
		Messages.getString("resultTreeNode.addTargetNode"); //$NON-NLS-1$
	
	public ResultTreeNode(Result result) {
		super(result);
	}

	protected void loadChildren() {
		Target[] targets = ((Result) maskatElement).getTargets();
		for (int i = 0; i < targets.length; i++) {
			if ("remote".equals(targets[i].getType())) {
				addChild(new TargetNode(targets[i]));
			}
		}
	}
	
	/**destroy the Target bean of the child after remove the child*/
	public void removeChild(ITreeNode child) {
		super.removeChild(child);
		maskatElement.removeChild(child.getModel());
	}
	
	/**add the model relation when add child*/
	public void addChild(ITreeNode child) {
		super.addChild(child);
		maskatElement.addChild(child.getModel());
	}

	public String getDisplayText() {
		if(((Result)maskatElement).getRootNode() == null
			|| ((Result)maskatElement).getRootNode().length() == 0)
			return ROOT_NODE_LABEL;
		
		Result result = (Result) maskatElement;
		return result.getRootNode() + " " + ROOT_NODE_LABEL;
	}
	
	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		final ITreeNode node = this;
		manager.add(new Action(ADD_TARGET_NODE){
			public void run() {
				Target target = new Target();
				target.setIn("");
				ITreeNode childNode = new TargetNode(target);
				EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));		
			}
		});
		return super.fillContextMenu(treeViewer, manager);
	}
}
