/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.core.event.Source;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.SourceChildNode;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.Validation;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteSourceNodeCommand extends DeleteOneTreeNodeCommand {
	private Source source = null;
	
	public DeleteSourceNodeCommand(TreeViewer treeViewer, ITreeNode parent, ITreeNode nodeToBeDeleted) {
		super(treeViewer, parent, nodeToBeDeleted);
	}

	public void execute() {
		if (nodeToBeDeleted.getModel() instanceof Source) {
			try {
				Source model = (Source) nodeToBeDeleted.getModel();
				this.source = (Source) model.clone();
			} catch (Exception e) {
				MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
			}
		}
		super.execute();
	}

	public void undo() {
		if (nodeToBeDeleted.getModel() instanceof Source) {
			Source model = (Source) nodeToBeDeleted.getModel();
			if (nodeToBeDeleted instanceof Validation) {
				model.setType(this.source.getType());
				model.setDesc(this.source.getDesc());
				model.setMin(this.source.getMin());
				model.setMax(this.source.getMax());
				model.setRegexp(this.source.getRegexp());
			} else if (nodeToBeDeleted instanceof SourceChildNode) {
				model.setChildNode(this.source.getChildNode());
			}
		}
		super.undo();
	}
}
