/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.sf.maskat.runtime.PropertyInitializer;

public class RialtoPropertyInitializer implements PropertyInitializer {

	public void initialize(Map properties, boolean enabled) {
		Map property = (Map) properties.get("rialto");
		if (property == null) {
			property = new LinkedHashMap();
			properties.put("rialto", property);
		}
		property.put("enabled", enabled ? Boolean.TRUE : Boolean.FALSE);
		property.put("isDebug", Boolean.FALSE);
		property.put("traceLevel", new Integer(0));	
		property.put("isTestVersion", Boolean.FALSE);
		property.put("language", "en");
		property.put("skin", "standart");
	}
}
