/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.commands.ChangePositionCommand;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LabelDirectEditable;
import jp.sf.maskat.widget.rialto.figure.TabFigure;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;


public class TabEditPart extends ComponentEditPart
		implements LabelDirectEditable {
	
	private int index;
	
	public TabEditPart(int index) {
		this.index = index;
	}
	
	protected IFigure createFigure() {
		return new TabFigure(getTitle());
	}

	public int getIndex() {
		return index;
	}

	public void setIndex(int index) {
		this.index = index;
	}
	
	protected void fireSelectionChanged() {
		((TabFolderEditPart) getParent()).setActivePage(this);
		super.fireSelectionChanged();
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("title".equals(evt.getPropertyName())) {
			((TabFigure) getFigure()).setText(getTitle());
		}
		super.propertyChange(evt);
	}
	
	protected void refreshVisuals() {
		if (getParent() != null && getParent() instanceof TabFolderEditPart) {
			int width = ((TabFolderEditPart) getParent()).getWidthTabName();
			Rectangle constraint = new Rectangle(index * width, 0, width, 20);
			GraphicalEditPart editPart = (GraphicalEditPart) getParent();
			if (editPart instanceof GraphicalEditPart) {
				editPart.setLayoutConstraint(this, getFigure(), constraint);
			}
		}
	}	

	public Command createConstrainCommand(Object model, Rectangle constraint) {
		if (model instanceof Component) {
			return new ChangePositionCommand((Component) model);
		}
		return null;
	}
	
	public String getTitle() {
		return (String) ((DynaComponent) getModel()).get("title");
	}

	public void setTitle(String text) {
		((DynaComponent) getModel()).set("title", text);
	}
	
	public String getLabel() {
		return getTitle();
	}

	public void setLabel(String text) {
		setTitle(text);
	}
}
