/*
 * Copyright (c) 2006-2009 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import jp.sf.maskat.widget.rialto.editpart.SplitLineEditPart;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class SplitterLayoutEditPolicy extends ComponentXYLayoutEditPolicy {
	
	public SplitterLayoutEditPolicy(int style) {
		super(style);
	}
	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		Command cmd = null;
		if (child instanceof ComponentEditPart) {
			ComponentEditPart part = (ComponentEditPart) child;
			if (child instanceof SplitLineEditPart) {
				cmd = part.createConstrainCommand(child.getModel(), (Rectangle) constraint);			
			} else { 
				if (isCheckConstraint((Rectangle) constraint)) {
					cmd = part.createConstrainCommand(child.getModel(), (Rectangle) constraint);
				}
			}
		}
		return cmd;
	}
	
	private boolean isCheckConstraint(Rectangle rec) {
		return !(rec.x < 0 || rec.y < 0);
	}
}
