/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.betwixt;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import jp.sf.maskat.core.betwixt.MaskatNamespacePrefixMapper;
import jp.sf.maskat.core.betwixt.MaskatXMLIntrospector;
import jp.sf.maskat.core.layout.ComponentLibrary;
import jp.sf.maskat.core.layout.ComponentRegistry;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.io.WriteContext;
import org.apache.commons.betwixt.strategy.NamespacePrefixMapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MaskatBeanWriter
extends BeanWriter {
    public MaskatBeanWriter() {
        this.setXMLIntrospector(new MaskatXMLIntrospector());
    }

    public MaskatBeanWriter(Writer writer) {
        super(writer);
        this.setXMLIntrospector(new MaskatXMLIntrospector());
    }

    protected void startElement(WriteContext context, String uri, String localName, String qualifiedName, Attributes attr) throws IOException, SAXException {
        if ("children".equals(qualifiedName) && attr.getLength() <= 0) {
            return;
        }
        if ("layoutDef".equals(qualifiedName)) {
            NamespacePrefixMapper mapper = this.getXMLIntrospector().getConfiguration().getPrefixMapper();
            Map prefixMap = ((MaskatNamespacePrefixMapper)mapper).getPrefixes();
            AttributesImpl attribute = new AttributesImpl();
            for (String key : prefixMap.keySet()) {
                if (this.isDefaultNamespaceURI((String)prefixMap.get(key))) continue;
                attribute.addAttribute("", "", "xmlns:" + key, "NOTATION", (String)prefixMap.get(key));
            }
            attr = attribute;
        }
        if (this.isDefaultComponent(qualifiedName)) {
            super.startElement(context, uri, localName, localName, attr);
        } else {
            super.startElement(context, uri, localName, qualifiedName, attr);
        }
    }

    private boolean isDefaultComponent(String qualifiedName) {
        int pos = qualifiedName.indexOf(":");
        if (pos == -1) {
            return false;
        }
        String prefix = qualifiedName.substring(0, pos);
        String localName = qualifiedName.substring(pos + 1);
        ComponentLibrary[] defaultLibrarys = ComponentRegistry.getDefaultLibrarys();
        int i = 0;
        while (i < defaultLibrarys.length) {
            if (defaultLibrarys[i].getPrefix().equals(prefix) && defaultLibrarys[i].containsComponent(localName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDefaultNamespaceURI(String namespace) {
        ComponentLibrary[] defaultLibrarys = ComponentRegistry.getDefaultLibrarys();
        int i = 0;
        while (i < defaultLibrarys.length) {
            if (defaultLibrarys[i].getNamespaceURI().equals(namespace)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void endElement(WriteContext context, String uri, String localName, String qualifiedName) throws IOException, SAXException {
        if ("children".equals(qualifiedName)) {
            return;
        }
        if (this.isDefaultComponent(qualifiedName)) {
            super.endElement(context, uri, localName, localName);
        } else {
            super.endElement(context, uri, localName, qualifiedName);
        }
    }

    public boolean getWriteEmptyElements() {
        return true;
    }
}

