/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.betwixt;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.betwixt.MessageSchemaValueSuppressionStrategy;
import jp.sf.maskat.core.event.EventElement;
import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.core.event.Result;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanWriter;
import org.apache.commons.betwixt.strategy.ValueSuppressionStrategy;
import org.apache.commons.io.IOUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MessageSchemaGenerator {
    public static final String MESSAGE_XSD_CONFIG = "xsdConfig.betwixt";

    public static InputStream generateRequestXMLSchema(Param param) throws IntrospectionException, IOException, SAXException {
        return MessageSchemaGenerator.generateMessageXMLSchema(param);
    }

    public static InputStream generateResponseXMLSchema(Result result) throws IntrospectionException, IOException, SAXException {
        return MessageSchemaGenerator.generateMessageXMLSchema(result);
    }

    private static InputStream generateMessageXMLSchema(EventElement element) throws IntrospectionException, IOException, SAXException {
        StringWriter outputWriter = new StringWriter();
        outputWriter.write("<?xml version='1.0' encoding='UTF-8' ?>");
        String lineSeparator = System.getProperty("line.separator");
        outputWriter.write(lineSeparator);
        BeanWriter beanWriter = new BeanWriter((Writer)outputWriter);
        beanWriter.getXMLIntrospector().getConfiguration().setAttributesForPrimitives(false);
        beanWriter.getBindingConfiguration().setMapIDs(false);
        beanWriter.getBindingConfiguration().setValueSuppressionStrategy((ValueSuppressionStrategy)new MessageSchemaValueSuppressionStrategy());
        beanWriter.enablePrettyPrint();
        beanWriter.setInitialIndentLevel(0);
        beanWriter.setWriteEmptyElements(false);
        XMLIntrospector intro = beanWriter.getXMLIntrospector();
        InputStream in = null;
        try {
            in = MaskatBeanIO.class.getResourceAsStream(MESSAGE_XSD_CONFIG);
            intro.register(new InputSource(in));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        beanWriter.write((Object)element);
        return IOUtils.toInputStream((String)outputWriter.toString());
    }
}

