/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.core.event;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.sf.maskat.core.event.AbstractEventElement;
import jp.sf.maskat.core.event.Event;

public class Component
extends AbstractEventElement {
    private String id;
    private Map events = new HashMap();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addChild(Object child) {
        super.addChild(child);
        if (child instanceof Event) {
            this.addEvent((Event)child);
        }
    }

    private void addEvent(Event event) {
        this.events.put(event.getId(), event);
    }

    public Event removeEvent(String id) {
        return (Event)this.events.remove(id);
    }

    public Event findEvent(String id) {
        return (Event)this.events.get(id);
    }

    public void setEvent(Event event) {
        int index = this.getChildIndex(event);
        if (index != -1) {
            List list = this.getChildren();
            list.set(index, event);
            event.setParent(this);
            this.addEvent(event);
        } else {
            this.addChild(event);
        }
    }

    private int getChildIndex(Event event) {
        List list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            Object child = list.get(i);
            if (child instanceof Event && event.getId().equals(((Event)child).getId())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasEvents() {
        return !this.events.isEmpty();
    }

    public boolean hasEnabledEvents() {
        if (this.events.isEmpty()) {
            return false;
        }
        Iterator it = this.events.values().iterator();
        while (it != null && it.hasNext()) {
            if (!((Event)it.next()).isEnable()) continue;
            return true;
        }
        return false;
    }

    public Event[] getAllEvents() {
        if (this.events.isEmpty()) {
            return new Event[0];
        }
        return this.events.values().toArray(new Event[0]);
    }
}

