/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui;

import java.io.IOException;
import jp.sf.maskat.ui.LayoutEditorDialogArea;
import jp.sf.maskat.ui.MaskatFrameworkDialogArea;
import jp.sf.maskat.ui.MaskatNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MaskatProjectPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private MaskatNature nature;
    private MaskatFrameworkDialogArea frameworkArea;
    private LayoutEditorDialogArea layoutArea;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        this.frameworkArea = new MaskatFrameworkDialogArea(project, composite, 0){

            public void setValid(boolean valid) {
                MaskatProjectPropertyPage.this.setValid(valid);
            }

            public void setErrorMessage(String newMessage) {
                MaskatProjectPropertyPage.this.setErrorMessage(newMessage);
            }
        };
        this.layoutArea = new LayoutEditorDialogArea(composite, 0){

            public void setValid(boolean valid) {
                MaskatProjectPropertyPage.this.setValid(valid);
            }

            public void setErrorMessage(String newMessage) {
                MaskatProjectPropertyPage.this.setErrorMessage(newMessage);
            }
        };
        this.initPage();
        this.setErrorMessage(null);
        this.setMessage(null);
        return composite;
    }

    private void initPage() {
        this.frameworkArea.setMaskatFWPath(this.getMaskatNature().getMaskatFrameworkPath());
        this.layoutArea.setGridSelection(this.getMaskatNature().getGridSelection());
        this.layoutArea.setSnapToGridSelection(this.getMaskatNature().getSnapToGridSelection());
        this.layoutArea.setSnapToObjectSelection(this.getMaskatNature().getSnapToGeometrySelection());
        this.layoutArea.setGridSize(this.getMaskatNature().getGridSize());
    }

    public boolean performOk() {
        MaskatNature nature = this.getMaskatNature();
        nature.setMaskatFrameworkPath((IPath)new Path(this.frameworkArea.getMaskatFWPath()));
        nature.setGridSelection(this.layoutArea.getGridSelection());
        nature.setSnapToGridSelection(this.layoutArea.getSnapToGridSelection());
        nature.setSnapToGeometrySelection(this.layoutArea.getSnapToObjectSelection());
        nature.setGridSize(this.layoutArea.getGridSize());
        try {
            nature.getPreferenceStore().save();
        }
        catch (IOException iOException) {
            return false;
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.frameworkArea.setMaskatFWPath((IPath)new Path("./maskat"));
        this.layoutArea.setGridSelection(new Boolean("false"));
        this.layoutArea.setSnapToGridSelection(new Boolean("false"));
        this.layoutArea.setSnapToObjectSelection(new Boolean("false"));
        this.layoutArea.setGridSize(new Integer("15"));
        super.performDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaskatNature getMaskatNature() {
        Class<MaskatNature> clazz = MaskatNature.class;
        synchronized (MaskatNature.class) {
            if (this.nature == null) {
                IProject project = (IProject)this.getElement().getAdapter(IProject.class);
                this.nature = MaskatNature.getNature(project);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nature;
        }
    }
}

