/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors;

import java.util.List;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.LayoutGraphicalEditor;
import jp.sf.maskat.ui.editors.layout.editpolicies.PopupBarDescriptorRegistory;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.ActionFactory;

public class LayoutEditorMenuManager
extends MenuManager {
    private SubMenuManager menuWrapper;
    private ISelectionProvider provider;
    private static final String MENUTITLE = Messages.getString("layout.contextmenu.newItem");

    public LayoutEditorMenuManager(LayoutGraphicalEditor editor) {
        this.provider = editor.getSite().getSelectionProvider();
        this.menuWrapper = new SubMenuManager((IMenuManager)this);
        this.menuWrapper.setVisible(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List commands;
                LayoutEditorMenuManager.this.menuWrapper.removeAll();
                EditPart editPart = LayoutEditorMenuManager.this.getAdditionalEditPart(LayoutEditorMenuManager.this.getSelectedEditPart());
                if (editPart != null && (commands = PopupBarDescriptorRegistory.getMenuActions(editPart)).size() > 0) {
                    MenuManager menu = new MenuManager(MENUTITLE);
                    int i = 0;
                    while (i < commands.size()) {
                        Object command = commands.get(i);
                        if (command instanceof IAction) {
                            menu.add((IAction)command);
                        } else if (command instanceof IContributionItem) {
                            menu.add((IContributionItem)command);
                        }
                        ++i;
                    }
                    LayoutEditorMenuManager.this.menuWrapper.insertBefore(ActionFactory.UNDO.getId(), (IContributionItem)menu);
                    LayoutEditorMenuManager.this.menuWrapper.insertBefore(ActionFactory.UNDO.getId(), (IContributionItem)new Separator());
                }
            }
        });
    }

    private EditPart getSelectedEditPart() {
        Object editPart;
        ISelection obj = this.provider.getSelection();
        if (obj instanceof IStructuredSelection && (editPart = ((IStructuredSelection)obj).getFirstElement()) instanceof EditPart) {
            return (EditPart)editPart;
        }
        return null;
    }

    private EditPart getAdditionalEditPart(EditPart select) {
        while (select != null && select.getEditPolicy((Object)"popupbar") == null) {
            select = select.getParent();
        }
        return select;
    }
}

