/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout;

import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.sf.maskat.core.betwixt.MaskatBeanIO;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutDef;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.SAXException;

public class MaskatResources {
    private LayoutDef layoutDef = null;
    private EventDef eventDef;
    private IFile layoutXMLFile;
    private IFile eventXMLFile;

    MaskatResources(IFile layoutXMLFile) {
        this.layoutXMLFile = layoutXMLFile;
        IContainer folder = layoutXMLFile.getParent();
        String eventXMLFileName = String.valueOf(layoutXMLFile.getLocation().removeFileExtension().lastSegment()) + "_e.xml";
        this.eventXMLFile = folder.getFile((IPath)new Path(eventXMLFileName));
    }

    public IFile getLayoutXMLFile() {
        return this.layoutXMLFile;
    }

    public IFile getEventXMLFile() {
        return this.eventXMLFile;
    }

    Layout getLayout() {
        Layout[] layouts = this.layoutDef.getLayouts();
        return layouts.length > 0 ? layouts[0] : null;
    }

    public void load() throws CoreException, IntrospectionException, IOException, SAXException {
        this.loadLayout();
        this.loadEvent();
        this.connect();
    }

    void connect() {
        this.layoutDef.setEventDef(this.eventDef);
    }

    void loadLayout() throws CoreException, IntrospectionException, IOException, SAXException {
        InputStream in = null;
        try {
            if (this.layoutXMLFile.exists()) {
                in = this.layoutXMLFile.getContents();
                this.layoutDef = MaskatBeanIO.readLayoutDef((InputStream)in);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    void loadEvent() throws CoreException, SAXException, IOException, IntrospectionException {
        if (!this.eventXMLFile.exists()) {
            this.eventDef = new EventDef();
            return;
        }
        InputStream in = null;
        try {
            this.eventXMLFile.refreshLocal(1, null);
            if (this.eventXMLFile.exists()) {
                in = this.eventXMLFile.getContents();
                this.eventDef = MaskatBeanIO.readEventDef((InputStream)in);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public void save() throws IntrospectionException, IOException, SAXException, CoreException {
        this.writeLayout();
        this.writeEvent();
    }

    private void writeLayout() throws IntrospectionException, IOException, SAXException, CoreException {
        String output = MaskatBeanIO.writeLayoutDef((LayoutDef)this.layoutDef);
        byte[] bytes = output.getBytes("UTF-8");
        this.layoutXMLFile.setContents((InputStream)new ByteArrayInputStream(bytes), false, false, null);
    }

    private void writeEvent() throws IntrospectionException, IOException, SAXException, CoreException {
        if (this.eventDef == null) {
            return;
        }
        String result = MaskatBeanIO.writeEventDef((EventDef)this.eventDef);
        if (!this.eventXMLFile.exists()) {
            this.eventXMLFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        }
        this.eventXMLFile.setContents((InputStream)new ByteArrayInputStream(result.getBytes("UTF-8")), false, false, null);
        this.eventDef.prepareEvent();
    }

    public EventDef getEventDef() {
        return this.eventDef;
    }

    public LayoutDef getLayoutDef() {
        return this.layoutDef;
    }
}

