/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import java.util.ArrayList;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.editparts.DynaComponentEditPartFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class ChainedEditPartFactory
implements EditPartFactory {
    private EditPartFactory[] factories;

    public ChainedEditPartFactory() {
        this.init();
    }

    private void init() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("jp.sf.maskat.ui", "editPartFactories");
        IExtension[] extensions = point.getExtensions();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    IConfigurationElement element = elements[j];
                    if ("factory".equals(element.getName())) {
                        result.add(element.createExecutableExtension("class"));
                    }
                }
                catch (CoreException e) {
                    MaskatUIPlugin.log(e.getStatus());
                }
                ++j;
            }
            ++i;
        }
        result.add(new DynaComponentEditPartFactory());
        this.factories = result.toArray(new EditPartFactory[result.size()]);
    }

    public EditPart createEditPart(EditPart context, Object model) {
        if (this.factories == null) {
            return null;
        }
        EditPart editPart = null;
        int i = 0;
        while (i < this.factories.length) {
            editPart = this.factories[i].createEditPart(context, model);
            if (editPart != null) {
                return editPart;
            }
            ++i;
        }
        return null;
    }
}

