/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editpolicies.ComponentXYLayoutEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.DataBindingEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.LabelDirectEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.ui.editors.layout.editpolicies.PopupBarDescriptorRegistory;
import jp.sf.maskat.ui.editors.layout.editpolicies.PopupBarEditPolicy;
import jp.sf.maskat.ui.editors.layout.figures.DynaComponentFigure;
import jp.sf.maskat.ui.editors.layout.figures.IFigureFactory;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;

public class DynaComponentEditPart
extends ComponentEditPart {
    private int width = 10;
    private int height = 10;
    private DynaComponentClass dynaClass;
    private IFigureFactory figureFactory;

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFigureFactory(IFigureFactory figureFactory) {
        this.figureFactory = figureFactory;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.dynaClass = (DynaComponentClass)((DynaComponent)model).getDynaClass();
    }

    protected IFigure createFigure() {
        DynaComponent component = (DynaComponent)this.getModel();
        if (this.figureFactory != null) {
            return this.figureFactory.createFigure(component);
        }
        String name = component.getName();
        if (name == null) {
            name = this.dynaClass.getName();
        }
        if (this.dynaClass.isContainer()) {
            return new DynaComponentFigure(name, 1);
        }
        return new DynaComponentFigure(name);
    }

    protected void createEditPolicies() {
        DynaComponent component = (DynaComponent)this.getModel();
        DynaComponentClass dynaClass = (DynaComponentClass)component.getDynaClass();
        int style = 0;
        if (dynaClass.isWidthResizable()) {
            style |= 0x18;
        }
        if (dynaClass.isHeightResizable()) {
            style |= 5;
        }
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new MaskatComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ComponentXYLayoutEditPolicy(style));
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
        this.installEditPolicy("data binding", (EditPolicy)new DataBindingEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        if (PopupBarDescriptorRegistory.containsDescriptor((EditPart)this)) {
            this.installEditPolicy("popupbar", (EditPolicy)new PopupBarEditPolicy());
        }
    }

    protected void refreshVisuals() {
        DynaComponent component = (DynaComponent)this.getModel();
        Rectangle constraint = new Rectangle(component.getLeft(), component.getTop(), this.dynaClass.isWidthResizable() ? component.getWidth() : this.width, this.dynaClass.isHeightResizable() ? component.getHeight() : this.height);
        if (this.getParent() != null) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("addChild".equals(evt.getPropertyName()) || "removeChild".equals(evt.getPropertyName())) {
            this.refresh();
        }
        super.propertyChange(evt);
    }

    protected List getModelChildren() {
        List result = null;
        if (this.getModel() instanceof MaskatElement) {
            result = ((MaskatElement)this.getModel()).getChildren();
        }
        return result != null ? result : super.getModelChildren();
    }
}

