/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.figures;

import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;
import jp.sf.maskat.ui.editors.layout.figures.DynaComponentFigure;
import jp.sf.maskat.ui.editors.layout.figures.IFigureFactory;
import jp.sf.maskat.ui.editors.layout.figures.TextFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FrameBorder;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;

public class DynaComponentFigureFactory
implements IFigureFactory {
    private String type;

    public DynaComponentFigureFactory(String type) {
        this.type = type;
    }

    public IFigure createFigure(Object model) {
        DynaComponent component = (DynaComponent)model;
        DynaComponentClass dynaClass = (DynaComponentClass)component.getDynaClass();
        String name = component.getName();
        if (name == null) {
            name = component.getDynaClass().getName();
        }
        Label figure = null;
        if (this.type != null) {
            FrameBorder border;
            Label label;
            if ("label".equals(this.type)) {
                label = new Label();
                label.setText(name);
                figure = label;
            }
            if ("button".equals(this.type)) {
                Button button = new Button(name);
                figure = button;
            }
            if ("frame".equals(this.type)) {
                label = new Label();
                border = new FrameBorder();
                border.setLabel(name);
                label.setBorder((Border)new CompoundBorder((Border)border, (Border)new MarginBorder(4)));
                figure = label;
            }
            if ("groupbox".equals(this.type)) {
                label = new Label();
                border = new GroupBoxBorder();
                border.setLabel(name);
                label.setBorder((Border)border);
                figure = label;
            }
            if ("rectangle".equals(this.type)) {
                label = new Label();
                label.setText(name);
                label.setBorder((Border)new CompoundBorder((Border)new LineBorder(), (Border)new MarginBorder(1)));
                figure = label;
            }
            if ("roundedRectangle".equals(this.type)) {
                RoundedRectangle rounded = new RoundedRectangle();
                rounded.setCornerDimensions(new Dimension(16, 16));
                figure = rounded;
            }
            if ("ellipse".equals(this.type)) {
                figure = new Ellipse();
            }
            if (figure != null) {
                figure.setForegroundColor(ColorConstants.black);
                figure.setFont(TextFigure.DEFAULT_FONT);
                figure.setOpaque(true);
                figure.setLayoutManager((LayoutManager)new XYLayout());
                return figure;
            }
        }
        if (dynaClass.isContainer()) {
            return new DynaComponentFigure(name, 1);
        }
        return new DynaComponentFigure(name);
    }
}

