/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Desc;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.Evaluator;
import jp.sf.maskat.core.layout.JavaScript;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.UnknownComponent;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.editors.layout.editparts.DynaComponentEditPartFactory;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;
import jp.sf.maskat.ui.editors.layout.editpolicies.MaskatComponentEditPolicy;
import jp.sf.maskat.ui.views.properties.AbstractComponentPropertySource;
import jp.sf.maskat.ui.views.properties.DynaBeanPropertySource;
import jp.sf.maskat.ui.views.properties.LayoutPropertySource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public class OutLineTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    private EditPart layoutEditPart = null;
    private Image image = null;

    public OutLineTreeEditPart(EditPart layoutPart) {
        this.layoutEditPart = layoutPart;
    }

    public void activate() {
        super.activate();
        if (this.getModel() instanceof Component) {
            ((Component)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void deactivate() {
        if (this.getModel() instanceof Component) {
            ((Component)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.deactivate();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("addChild".equals(name) || "removeChild".equals(name)) {
            this.refresh();
        } else if ("gridHeaderTitle".equals(name)) {
            Iterator it = this.getChildren().iterator();
            while (it != null && it.hasNext()) {
                ((EditPart)it.next()).refresh();
            }
        }
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        List result = null;
        Object model = this.getModel();
        if (model instanceof MaskatElement) {
            result = ((MaskatElement)model).getChildren();
        }
        return result != null ? result : super.getModelChildren();
    }

    protected void refreshVisuals() {
        this.setWidgetText(this.getOutlineLabel());
        this.setWidgetImage(this.getOutlineImage());
    }

    protected void createEditPolicies() {
        MaskatComponentEditPolicy newPolicy = null;
        if (this.layoutEditPart != null) {
            GraphicalEditPart editPart = (GraphicalEditPart)this.layoutEditPart;
            EditPolicy policy = editPart.getEditPolicy((Object)"ComponentEditPolicy");
            if (policy != null) {
                if (policy instanceof MaskatComponentEditPolicy) {
                    newPolicy = ((MaskatComponentEditPolicy)policy).cloneEditPolicy();
                } else {
                    newPolicy = new MaskatComponentEditPolicy();
                    newPolicy.setHost(policy.getHost());
                }
            } else {
                newPolicy = new MaskatComponentEditPolicy();
            }
        }
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)newPolicy);
    }

    public void setLayoutEditPart(EditPart editPart) {
        this.layoutEditPart = editPart;
    }

    public EditPart getLayoutEditPart() {
        return this.layoutEditPart;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySource.class)) {
            Object object = Platform.getAdapterManager().getAdapter(this.getModel(), key);
            if (object instanceof AbstractComponentPropertySource) {
                ((AbstractComponentPropertySource)object).setCommandStack(this.getViewer().getEditDomain().getCommandStack());
            } else if (object instanceof LayoutPropertySource) {
                ((LayoutPropertySource)object).setCommandStack(this.getViewer().getEditDomain().getCommandStack());
            } else if (object instanceof DynaBeanPropertySource) {
                ((DynaBeanPropertySource)object).setCommandStack(this.getViewer().getEditDomain().getCommandStack());
            }
            return object;
        }
        if (key.isAssignableFrom(this.getModel().getClass())) {
            return this.getModel();
        }
        return super.getAdapter(key);
    }

    private String getOutlineLabel() {
        Object model = this.getModel();
        if (model == null) {
            return null;
        }
        if (this.layoutEditPart != null && this.layoutEditPart instanceof LayoutElementEditPart) {
            return ((LayoutElementEditPart)this.layoutEditPart).getOutlineLabel();
        }
        StringBuffer sb = new StringBuffer(" ");
        String className = null;
        className = model instanceof UnknownComponent ? ((UnknownComponent)model).getDynaClass().getName() : (model instanceof DynaComponent ? ((DynaComponent)model).getDynaClass().getName() : model.getClass().getName());
        className = className.substring(className.lastIndexOf(".") + 1);
        sb.append(className);
        return sb.toString();
    }

    private Image getOutlineImage() {
        ImageDescriptor desc;
        if (this.image != null) {
            return this.image;
        }
        Object model = this.getModel();
        this.image = model instanceof Layout ? MaskatUIPlugin.getImage("IMG_COMPONENT_AYOUT") : (model instanceof JavaScript ? MaskatUIPlugin.getImage("IMG_COMPONENT_JAVASCRIPT") : (model instanceof Desc ? MaskatUIPlugin.getImage("IMG_COMPONENT_DESC") : (model instanceof Evaluator ? MaskatUIPlugin.getImage("IMG_COMPONENT_EVALUATOR") : (model instanceof DynaComponent ? ((desc = DynaComponentEditPartFactory.getImageDescriptor(model)) == null ? MaskatUIPlugin.getImage("IMG_COMPONENT_CUSTOM") : desc.createImage()) : MaskatUIPlugin.getImage("IMG_COMPONENT_UNKNOWN")))));
        return this.image;
    }
}

