/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.tools;

import java.util.ArrayList;
import java.util.List;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutElement;

public class ComponentUtils {
    public static boolean isExistenceId(LayoutElement root, String id) {
        if (root instanceof Component && id.equals(((Component)root).getName())) {
            return true;
        }
        List elements = root.getChildren();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            if (element instanceof LayoutElement) {
                if (element instanceof Component && id.equals(((Component)element).getName())) {
                    return true;
                }
                boolean exist = ComponentUtils.isExistenceId((LayoutElement)element, id);
                if (exist) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static LayoutElement getLayoutElement(LayoutElement root, String id) {
        if (root instanceof Component && id.equals(((Component)root).getName())) {
            return root;
        }
        List elements = root.getChildren();
        int i = 0;
        while (i < elements.size()) {
            Object element = elements.get(i);
            if (element instanceof LayoutElement) {
                if (element instanceof Component && id.equals(((Component)element).getName())) {
                    return (LayoutElement)element;
                }
                LayoutElement exist = ComponentUtils.getLayoutElement((LayoutElement)element, id);
                if (exist != null) {
                    return exist;
                }
            }
            ++i;
        }
        return null;
    }

    public static void setUniqueName(Layout layout, Component component) {
        ComponentUtils.setUniqueName(layout, component, new ArrayList());
    }

    private static void setUniqueName(Layout layout, Component component, List invalidList) {
        String name = component.getName();
        String newName = ComponentUtils.getUniqueName((LayoutElement)layout, name, invalidList);
        if (!newName.equals(name)) {
            try {
                component.setName(newName);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        List components = component.getTypedChildren(Component.class);
        int i = 0;
        while (i < components.size()) {
            ComponentUtils.setUniqueName(layout, (Component)components.get(i), invalidList);
            ++i;
        }
    }

    public static String getUniqueName(LayoutElement root, String baseName) {
        return ComponentUtils.getUniqueName(root, baseName, null);
    }

    public static String getUniqueName(LayoutElement root, String baseName, List invalidList) {
        int i;
        List componentList = ComponentUtils.getAllComponentList(root);
        if (baseName == null || "".equals(baseName)) {
            baseName = "widget";
        } else {
            if (!componentList.contains(baseName) && !invalidList.contains(baseName)) {
                invalidList.add(baseName);
                return baseName;
            }
            i = baseName.length() - 1;
            while (i >= 0) {
                String id = baseName.substring(i, i + 1);
                try {
                    Integer.parseInt(id);
                }
                catch (NumberFormatException numberFormatException) {
                    baseName = baseName.substring(0, i + 1);
                    break;
                }
                --i;
            }
        }
        i = 0;
        while (i < Integer.MAX_VALUE) {
            StringBuffer sb = new StringBuffer(baseName);
            if (i != 0) {
                sb.append(i);
            }
            if (!componentList.contains(sb.toString()) && !invalidList.contains(sb.toString())) {
                invalidList.add(sb.toString());
                return sb.toString();
            }
            ++i;
        }
        return null;
    }

    private static List getAllComponentList(LayoutElement element) {
        ArrayList<String> list = new ArrayList<String>();
        List elements = element.getChildren();
        int i = 0;
        while (i < elements.size()) {
            Object object = elements.get(i);
            if (object instanceof LayoutElement) {
                if (object instanceof Component) {
                    list.add(((Component)object).getName());
                }
                list.addAll(ComponentUtils.getAllComponentList((LayoutElement)object));
            }
            ++i;
        }
        return list;
    }
}

