/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.tools;

import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.editparts.IdDirectEditable;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import jp.sf.maskat.ui.editors.layout.tools.DirectEditable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IdTextCellEditor
extends TextCellEditor
implements DirectEditable {
    IdDirectEditable editable;
    EditPart targetEditPart;

    public IdTextCellEditor(Composite parent, int style, EditPart editPart) {
        super(parent, style);
        this.targetEditPart = editPart;
        this.editable = (IdDirectEditable)editPart.getAdapter(IdDirectEditable.class);
    }

    public String get() {
        return this.editable.getId();
    }

    public void set(String id) {
        LayoutElement element = (LayoutElement)this.targetEditPart.getModel();
        if (id == null || id.length() <= 0) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("outline.msg.warning.title"), (String)Messages.getString("outline.msg.error.noname"));
        } else if (ComponentUtils.isExistenceId((LayoutElement)element.getLayout(), id)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("outline.msg.warning.title"), (String)Messages.getString("outline.msg.error.existencename"));
        } else {
            this.editable.setId(id);
        }
    }
}

