/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.TargetingTool;

public class PopupBarTool
extends TargetingTool
implements DragTracker {
    private CreationFactory factory;
    private CreateRequest currentRequest;
    private EditPart targetEditPart;
    private static final int FLAG_LOCK_TARGET = 16;

    public PopupBarTool(EditPart editPart, CreationFactory factory) {
        this.factory = factory;
        this.targetEditPart = editPart;
        this.lockTargetEditPart(editPart);
    }

    protected void lockTargetEditPart(EditPart editpart) {
        if (editpart == null) {
            this.unlockTargetEditPart();
            return;
        }
        this.setFlag(16, true);
        this.setTargetEditPart(editpart);
    }

    protected EditPart getTargetEditPart() {
        return this.targetEditPart;
    }

    protected void unlockTargetEditPart() {
    }

    protected boolean handleButtonDown(int button) {
        this.setCurrentCommand(this.getCommand());
        return super.handleButtonDown(button);
    }

    protected boolean handleButtonUp(int button) {
        this.executeCurrentCommand();
        if (this.currentRequest != null) {
            Object editPart;
            Object model = this.currentRequest.getNewObject();
            EditPartViewer viewer = this.getCurrentViewer();
            if (model != null && viewer != null && (editPart = viewer.getEditPartRegistry().get(model)) instanceof EditPart) {
                viewer.select((EditPart)editPart);
            }
        }
        this.currentRequest = null;
        return true;
    }

    protected String getCommandName() {
        return "create child";
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.factory);
        request.setLocation(this.getMouseLocation());
        request.setSize(new Dimension(-1, -1));
        this.currentRequest = request;
        return request;
    }

    private Point getMouseLocation() {
        IFigure figure = ((GraphicalEditPart)this.targetEditPart).getFigure();
        Rectangle rect = figure.getBounds().getCopy();
        Insets inset = figure.getInsets();
        if (inset != null) {
            rect.x += inset.left;
            rect.y += inset.top;
        }
        return new Point(rect.x, rect.y);
    }

    public boolean isCommandEnabled() {
        Command cmd = this.getCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void commitDrag() {
    }
}

