/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties;

import java.util.HashMap;
import java.util.Map;
import jp.sf.maskat.core.layout.AbstractComponent;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.UndoableSetPropertyCommand;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import jp.sf.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class AbstractComponentPropertySource
implements IPropertySource {
    public static final String PROP_NAME = "_prop_name_";
    public static final String PROP_LEFT = "_prop_left_";
    public static final String PROP_TOP = "_prop_top_";
    public static final String PROP_WIDTH = "_prop_width_";
    public static final String PROP_HEIGHT = "_prop_height_";
    protected static IPropertyDescriptor[] descriptor;
    protected static Map propMap;
    protected Object bean;
    private CommandStack commandStack;

    static {
        propMap = new HashMap();
    }

    public AbstractComponentPropertySource(Object bean) {
        this.bean = bean;
        this.initialize();
    }

    protected void initialize() {
        descriptor = new PropertyDescriptor[]{new MaskatTextPropertyDescriptor(PROP_NAME, "name"), new MaskatTextPropertyDescriptor(PROP_LEFT, "left"), new MaskatTextPropertyDescriptor(PROP_TOP, "top"), new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"), new MaskatTextPropertyDescriptor(PROP_HEIGHT, "height")};
        if (this.bean instanceof AbstractComponent) {
            propMap.put(PROP_NAME, "name");
            propMap.put(PROP_LEFT, "left");
            propMap.put(PROP_TOP, "top");
            propMap.put(PROP_WIDTH, "width");
            propMap.put(PROP_HEIGHT, "height");
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptor;
    }

    public Object getPropertyValue(Object id) {
        Object result = this.doGetPropertyValue(id);
        return result == null ? "" : result;
    }

    protected Object doGetPropertyValue(Object id) {
        if (id != null && propMap.containsKey(id)) {
            try {
                return BeanUtils.getProperty((Object)this.bean, (String)((String)propMap.get(id)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if ("".equals(value)) {
            value = null;
        }
        this.doSetPropertyValue(id, value);
    }

    protected void doSetPropertyValue(Object id, Object value) {
        if (id != null && propMap.containsKey(id)) {
            if (value != null && PROP_NAME.equals(id) && ComponentUtils.isExistenceId((LayoutElement)((LayoutElement)this.bean).getLayout(), (String)value)) {
                return;
            }
            if (value == null && PROP_NAME.equals(id)) {
                return;
            }
            if (this.commandStack != null) {
                String oldValue = null;
                try {
                    oldValue = BeanUtils.getProperty((Object)this.bean, (String)((String)propMap.get(id)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
                    this.commandStack.execute((Command)new UndoableSetPropertyCommand(this.bean, (String)propMap.get(id), value));
                }
                return;
            }
            try {
                BeanUtils.setProperty((Object)this.bean, (String)((String)propMap.get(id)), (Object)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }
}

