/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties;

import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Layout;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.editors.layout.commands.UndoableSetPropertyCommand;
import jp.sf.maskat.ui.editors.layout.tools.ComponentUtils;
import jp.sf.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LayoutPropertySource
implements IPropertySource {
    private static final String PROP_ID = "_prop_id_";
    private static final String PROP_NAME = "_prop_name_";
    private static final String PROP_REMOTEURL = "_prop_remoteurl_";
    private static final String PROP_ONLOAD = "_prop_onload_";
    private CommandStack commandStack;
    private static final IPropertyDescriptor[] descriptor = new PropertyDescriptor[]{new MaskatTextPropertyDescriptor("_prop_name_", "name"), new MaskatTextPropertyDescriptor("_prop_remoteurl_", "remoteUrl")};
    private Layout layout;
    private EventDef eventDef;

    public LayoutPropertySource(Layout layout) {
        this.layout = layout;
        this.eventDef = layout.getLayoutDef().getEventDef();
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptor;
    }

    public Object getPropertyValue(Object id) {
        Object result = this.doGetPropertyValue(id);
        return result == null ? "" : result;
    }

    public Object doGetPropertyValue(Object id) {
        if (PROP_ID.equals(id)) {
            return this.eventDef.getId();
        }
        if (PROP_REMOTEURL.equals(id)) {
            return this.eventDef.getRemoteUrl();
        }
        if (PROP_ONLOAD.equals(id)) {
            this.eventDef.findEvent("onload");
        }
        if (PROP_NAME.equals(id)) {
            return this.layout.getName();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if ("".equals(value)) {
            value = null;
        }
        this.doSetPropertyValue(id, value);
    }

    public void doSetPropertyValue(Object id, Object value) {
        if (PROP_ID.equals(id)) {
            if (this.commandStack != null && (value == null && this.eventDef.getId() != null && !"".equals(this.eventDef.getId()) || value != null && !value.equals(this.eventDef.getId()))) {
                this.commandStack.execute((Command)new UndoableSetPropertyCommand(this.eventDef, "id", value));
                return;
            }
            this.eventDef.setId((String)value);
        }
        if (PROP_REMOTEURL.equals(id)) {
            if (this.commandStack != null && (value == null && !"".equals(this.eventDef.getRemoteUrl()) || value != null && !value.equals(this.eventDef.getRemoteUrl()))) {
                this.commandStack.execute((Command)new UndoableSetPropertyCommand(this.eventDef, "remoteUrl", value));
                return;
            }
            this.eventDef.setRemoteUrl((String)value);
        }
        if (PROP_NAME.equals(id)) {
            if (value != null && PROP_NAME.equals(id) && ComponentUtils.isExistenceId((LayoutElement)this.layout, (String)value)) {
                return;
            }
            if (value == null && PROP_NAME.equals(id)) {
                return;
            }
            if (this.commandStack != null && (value == null && !"".equals(this.layout.getName()) || value != null && !value.equals(this.layout.getName()))) {
                this.commandStack.execute((Command)new UndoableSetPropertyCommand(this.layout, "name", value));
                return;
            }
            this.layout.setName((String)value);
        }
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }
}

