/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import java.util.ArrayList;
import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.Header;
import jp.sf.maskat.core.event.Param;
import jp.sf.maskat.core.event.Result;
import jp.sf.maskat.core.event.Target;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ChangeEventTypeCommand
extends Command {
    private TreeViewer treeViewer;
    private Event event;
    private String type;
    private Event oldEvent;

    public ChangeEventTypeCommand(TreeViewer treeViewer, Event event, String type) {
        try {
            this.treeViewer = treeViewer;
            this.event = event;
            this.oldEvent = (Event)event.clone();
            this.type = type;
        }
        catch (CloneNotSupportedException e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        try {
            if ("disable".equals(this.type)) {
                this.cleanEvent(this.event);
            } else if ("local".equals(this.type)) {
                this.makeEventLocal(this.event);
            } else {
                this.makeEventRemote(this.event);
            }
            ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.event, EventTreeNode.class);
            if (treeNode instanceof EventTreeNode) {
                this.treeViewer.refresh((Object)treeNode.getParent(), true);
                this.treeViewer.expandToLevel(2);
                treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.event, EventTreeNode.class);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)treeNode), true);
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public void undo() {
        try {
            ITreeNode treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.event, EventTreeNode.class);
            if (treeNode instanceof EventTreeNode) {
                this.setEvnetProperties(this.oldEvent, this.event);
                this.treeViewer.refresh((Object)treeNode.getParent(), true);
                this.treeViewer.expandToLevel(2);
                treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.event, EventTreeNode.class);
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)treeNode), true);
            }
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    private void cleanEvent(Event event) {
        event.removeAllChildren();
        event.setRemoteUrl(null);
        event.setStart(null);
        event.setBefore(null);
        event.setAfter(null);
        event.setFinish(null);
        event.setTimeout(-1);
        event.setAsync(true);
        event.setOnTimeoutError(null);
        event.setAfter(null);
        event.setEnable(false);
    }

    private void setEvnetProperties(Event old, Event event) {
        event.removeAllChildren();
        ArrayList chirdren = new ArrayList(old.getChildren());
        int i = 0;
        while (i < chirdren.size()) {
            event.addChild(chirdren.get(i));
            ++i;
        }
        event.setEnable(old.isEnable());
        event.setType(old.getType());
        event.setRemoteUrl(old.getRemoteUrl());
        event.setStart(old.getStart());
        event.setBefore(old.getBefore());
        event.setAfter(old.getAfter());
        event.setFinish(old.getFinish());
        event.setTimeout(old.getTimeout());
        event.setOnTimeoutError(old.getOnTimeoutError());
        event.setEnable(old.isEnable());
        event.setAsync(old.isAsync());
    }

    private void makeEventRemote(Event event) {
        event.setEnable(true);
        event.setType("remote");
        Result result = event.getResult();
        if (result != null) {
            Target[] targets = result.getTargets();
            int i = 0;
            while (i < targets.length) {
                targets[i].setTeleType(targets[i].getWorkType());
                targets[i].setWorkType(null);
                targets[i].setType("local");
                ++i;
            }
        }
    }

    private void makeEventLocal(Event event) {
        event.setEnable(true);
        event.setType("local");
        event.setBefore(null);
        event.setAfter(null);
        event.setRemoteUrl(null);
        event.setTimeout(-1);
        event.setAsync(true);
        event.setOnTimeoutError(null);
        if (event.getTypedChildren(Param.class) != null) {
            Param param = event.getParam();
            param.setEnable(false);
            param.removeAllChildren();
            param.setNs(null);
            param.setRootNode(null);
        }
        if (event.getTypedChildren(Result.class) != null) {
            Result result = event.getResult();
            result.setEnable(false);
            Target[] targets = result.getTargets();
            int i = 0;
            while (i < targets.length) {
                if ("remote".equals(targets[i].getType())) {
                    result.removeChild((Object)targets[i]);
                } else {
                    targets[i].setWorkType(targets[i].getTeleType());
                    targets[i].setTeleType(null);
                }
                ++i;
            }
            result.setRootNode(null);
            result.setOnErrorTele(null);
        }
        event.removeAllByType(Header.class);
    }
}

