/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteMultiTreeNodesCommand
extends Command {
    private TreeViewer treeViewer;
    private ITreeNode parentNode;
    private ITreeNode[] nodesToBeDeleted;

    public DeleteMultiTreeNodesCommand(TreeViewer treeViewer, ITreeNode[] nodesToBeDeleted) {
        this.treeViewer = treeViewer;
        this.parentNode = nodesToBeDeleted[0].getParent();
        this.nodesToBeDeleted = nodesToBeDeleted;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        try {
            int i = 0;
            while (i < this.nodesToBeDeleted.length) {
                this.parentNode.removeChild(this.nodesToBeDeleted[i]);
                ++i;
            }
            this.treeViewer.refresh((Object)this.parentNode, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.parentNode));
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public void undo() {
        try {
            ITreeNode newParentTreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(this.parentNode.getModel(), this.parentNode.getClass());
            this.parentNode = newParentTreeNode == null ? this.parentNode : newParentTreeNode;
            int i = 0;
            while (i < this.nodesToBeDeleted.length) {
                this.parentNode.addChild(this.nodesToBeDeleted[i]);
                ++i;
            }
            this.treeViewer.refresh((Object)this.parentNode, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.nodesToBeDeleted[0]), true);
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }
}

