/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteOneTreeNodeCommand
extends Command {
    protected TreeViewer treeViewer;
    protected ITreeNode parentTreeNode;
    protected ITreeNode nodeToBeDeleted;
    private ITreeNode selectRootNode = null;

    public DeleteOneTreeNodeCommand(TreeViewer treeViewer, ITreeNode parent, ITreeNode nodeToBeDeleted) {
        this.treeViewer = treeViewer;
        this.parentTreeNode = parent;
        this.nodeToBeDeleted = nodeToBeDeleted;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        try {
            this.parentTreeNode.removeChild(this.nodeToBeDeleted);
            if (this.selectRootNode == null) {
                this.selectRootNode = this.getSelectRootNode();
            } else if (this.selectRootNode != this.getSelectRootNode()) {
                this.selectRootNode = this.getSelectRootNode();
                this.treeViewer.refresh();
                this.treeViewer.expandToLevel(2);
                ITreeNode newtreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(this.parentTreeNode.getModel(), this.parentTreeNode.getClass());
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newtreeNode));
                return;
            }
            this.treeViewer.refresh((Object)this.parentTreeNode, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.parentTreeNode));
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    public void undo() {
        try {
            ITreeNode newParentTreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(this.parentTreeNode.getModel(), this.parentTreeNode.getClass());
            this.parentTreeNode = newParentTreeNode == null ? this.parentTreeNode : newParentTreeNode;
            this.parentTreeNode.addChild(this.nodeToBeDeleted);
            this.treeViewer.refresh((Object)this.parentTreeNode, true);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.nodeToBeDeleted), true);
        }
        catch (Exception e) {
            MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 4, e.getMessage(), (Throwable)e));
        }
    }

    private ITreeNode getSelectRootNode() {
        Object obj;
        TreeSelection selection = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] paths = selection.getPaths();
        if (paths.length > 0 && (obj = paths[0].getSegment(0)) instanceof ITreeNode) {
            return (ITreeNode)obj;
        }
        return null;
    }
}

