/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.masterdetails;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.LocalCallbackFunctions;
import jp.sf.maskat.ui.views.properties.tabbed.command.CompositePropertyCommand;
import jp.sf.maskat.ui.views.properties.tabbed.command.SetEventPropertyCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.AbstractMaskatDetailsPage;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LocalCallbackFunctionsDetailsPage
extends AbstractMaskatDetailsPage {
    private static final String SECTION_TEXT = Messages.getString("localCallbackDetails.sectionText");
    private static final String DESCRIPTION = Messages.getString("localCallbackDetails.description");
    private FormToolkit toolkit;
    private Section callbackFunctionsSection;
    private Composite remoteComposite;
    private Composite localComposite;
    private Text beforeValidationLocalText;
    private Text afterStoredLocalText;
    private Text beforeValidationRemoteText;
    private Text beforeSendText;
    private Text afterReceiveText;
    private Text afterStoredRemoteText;
    private Text timeOutTimerText;
    private Text onTimeOutText;
    private Event event;

    public LocalCallbackFunctionsDetailsPage(TreeViewer masterBlockTreeViewer) {
        this.masterBlockTreeViewer = masterBlockTreeViewer;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 5;
        layout.rightMargin = 5;
        layout.bottomMargin = 5;
        parent.setLayout((Layout)layout);
        this.toolkit = this.managedForm.getToolkit();
        this.callbackFunctionsSection = this.toolkit.createSection(parent, 384);
        this.callbackFunctionsSection.setText(SECTION_TEXT);
        this.callbackFunctionsSection.setDescription(DESCRIPTION);
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        this.callbackFunctionsSection.setLayoutData((Object)tableWrapData);
        this.createRemoteComposite();
        this.createLocalComposite();
    }

    public void refresh() {
        this.initializeInterface();
    }

    protected void initializeInterface() {
        this.update();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        this.update();
    }

    public void update() {
        if (this.event.getType().equals("remote")) {
            this.hideLocalComposite();
            this.showRemoteComposite();
            if (this.event.getStart() != null) {
                this.beforeValidationRemoteText.setText(this.event.getStart());
            } else {
                this.beforeValidationRemoteText.setText("");
            }
            if (this.event.getBefore() != null) {
                this.beforeSendText.setText(this.event.getBefore());
            } else {
                this.beforeSendText.setText("");
            }
            if (this.event.getAfter() != null) {
                this.afterReceiveText.setText(this.event.getAfter());
            } else {
                this.afterReceiveText.setText("");
            }
            if (this.event.getFinish() != null) {
                this.afterStoredRemoteText.setText(this.event.getFinish());
            } else {
                this.afterStoredRemoteText.setText("");
            }
            this.updateTimeOutText(true);
        } else if (this.event.getType().equals("local")) {
            this.hideRemoteComposite();
            this.showLocalComposite();
            if (this.event.getStart() != null) {
                this.beforeValidationLocalText.setText(this.event.getStart());
            } else {
                this.beforeValidationLocalText.setText("");
            }
            if (this.event.getFinish() != null) {
                this.afterStoredLocalText.setText(this.event.getFinish());
            } else {
                this.afterStoredLocalText.setText("");
            }
        }
        this.setDirtyFlag(false);
    }

    private void updateTimeOutText(boolean update) {
        if (this.event.getTimeout() >= 0) {
            if (update) {
                this.timeOutTimerText.setText(new Integer(this.event.getTimeout()).toString());
            }
            if (this.event.getOnTimeoutError() != null) {
                this.onTimeOutText.setText(this.event.getOnTimeoutError());
            } else {
                this.onTimeOutText.setText("");
            }
            this.onTimeOutText.setEnabled(true);
        } else {
            this.timeOutTimerText.setText("");
            this.onTimeOutText.setText("");
            this.onTimeOutText.setEnabled(false);
        }
    }

    private void showLocalComposite() {
        this.callbackFunctionsSection.setClient((Control)this.localComposite);
        this.localComposite.setVisible(true);
        this.callbackFunctionsSection.redraw();
        this.callbackFunctionsSection.update();
    }

    private void showRemoteComposite() {
        this.callbackFunctionsSection.setClient((Control)this.remoteComposite);
        this.remoteComposite.setVisible(true);
        this.callbackFunctionsSection.redraw();
        this.callbackFunctionsSection.update();
    }

    private void hideRemoteComposite() {
        this.remoteComposite.setVisible(false);
        this.callbackFunctionsSection.redraw();
        this.callbackFunctionsSection.update();
    }

    private void hideLocalComposite() {
        this.localComposite.setVisible(false);
        this.callbackFunctionsSection.redraw();
        this.callbackFunctionsSection.update();
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void createRemoteComposite() {
        this.remoteComposite = this.toolkit.createComposite((Composite)this.callbackFunctionsSection);
        this.remoteComposite.setLayout((Layout)new GridLayout(4, false));
        this.toolkit.createLabel(this.remoteComposite, Messages.getString("localCallbackDetails.beforeValidationLabel"));
        this.toolkit.createLabel(this.remoteComposite, ":");
        this.beforeValidationRemoteText = this.toolkit.createText(this.remoteComposite, this.event.getStart(), 2052);
        this.beforeValidationRemoteText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.toolkit.createLabel(this.remoteComposite, Messages.getString("localCallbackDetails.beforeDataSentLabel"));
        this.toolkit.createLabel(this.remoteComposite, ":");
        this.beforeSendText = this.toolkit.createText(this.remoteComposite, this.event.getBefore(), 2052);
        this.beforeSendText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.toolkit.createLabel(this.remoteComposite, Messages.getString("localCallbackDetails.AfterDataReceiveLabel"));
        this.toolkit.createLabel(this.remoteComposite, ":");
        this.afterReceiveText = this.toolkit.createText(this.remoteComposite, this.event.getAfter(), 2052);
        this.afterReceiveText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.toolkit.createLabel(this.remoteComposite, Messages.getString("localCallbackDetails.AfterDataStoreLabel"));
        this.toolkit.createLabel(this.remoteComposite, ":");
        this.afterStoredRemoteText = this.toolkit.createText(this.remoteComposite, this.event.getFinish(), 2052);
        this.afterStoredRemoteText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.toolkit.createLabel(this.remoteComposite, Messages.getString("localCallbackDetails.OnTimeoutLabel"));
        this.toolkit.createLabel(this.remoteComposite, ":");
        this.onTimeOutText = new Text(this.remoteComposite, 2052);
        this.onTimeOutText.setEnabled(false);
        this.onTimeOutText.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.toolkit.createLabel(this.remoteComposite, Messages.getString("localCallbackDetails.TimerLabel"));
        this.toolkit.createLabel(this.remoteComposite, ":");
        this.timeOutTimerText = this.toolkit.createText(this.remoteComposite, new Integer(this.event.getTimeout()).toString(), 2052);
        this.timeOutTimerText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.toolkit.createLabel(this.remoteComposite, "     ").setLayoutData((Object)new GridData(4, 0, true, false));
        this.beforeValidationRemoteText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                LocalCallbackFunctionsDetailsPage.this.updateBeanBeforeValidation(LocalCallbackFunctionsDetailsPage.this.beforeValidationRemoteText);
            }
        });
        this.beforeSendText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (LocalCallbackFunctionsDetailsPage.this.event.getBefore() == null || !LocalCallbackFunctionsDetailsPage.this.event.getBefore().equals(LocalCallbackFunctionsDetailsPage.this.beforeSendText.getText())) {
                    EventPropertiesMasterDetailsBlock.setEventProperty(LocalCallbackFunctionsDetailsPage.this.masterBlockTreeViewer, LocalCallbackFunctions.class, LocalCallbackFunctionsDetailsPage.this.event, "before", LocalCallbackFunctionsDetailsPage.this.beforeSendText.getText());
                }
            }
        });
        this.afterReceiveText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (LocalCallbackFunctionsDetailsPage.this.event.getAfter() == null || !LocalCallbackFunctionsDetailsPage.this.event.getAfter().equals(LocalCallbackFunctionsDetailsPage.this.afterReceiveText.getText())) {
                    EventPropertiesMasterDetailsBlock.setEventProperty(LocalCallbackFunctionsDetailsPage.this.masterBlockTreeViewer, LocalCallbackFunctions.class, LocalCallbackFunctionsDetailsPage.this.event, "after", LocalCallbackFunctionsDetailsPage.this.afterReceiveText.getText());
                }
            }
        });
        this.afterStoredRemoteText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                LocalCallbackFunctionsDetailsPage.this.updateBeanAfterStored(LocalCallbackFunctionsDetailsPage.this.afterStoredRemoteText);
            }
        });
        this.timeOutTimerText.addListener(25, (Listener)new AbstractMaskatDetailsPage.VerifyIntegerListener());
        this.timeOutTimerText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                int time = LocalCallbackFunctionsDetailsPage.this.event.getTimeout();
                int newTime = LocalCallbackFunctionsDetailsPage.this.getTextValueAsIntValue(LocalCallbackFunctionsDetailsPage.this.timeOutTimerText, time);
                String newText = LocalCallbackFunctionsDetailsPage.this.timeOutTimerText.getText();
                if ("".equals(newText)) {
                    newTime = -1;
                    newText = "-1";
                }
                if (time != newTime) {
                    if (newTime == -1) {
                        CompositePropertyCommand commands = new CompositePropertyCommand();
                        commands.addCommand(new SetEventPropertyCommand(LocalCallbackFunctionsDetailsPage.this.masterBlockTreeViewer, LocalCallbackFunctions.class, LocalCallbackFunctionsDetailsPage.this.event, "timeout", newText));
                        commands.addCommand(new SetEventPropertyCommand(LocalCallbackFunctionsDetailsPage.this.masterBlockTreeViewer, LocalCallbackFunctions.class, LocalCallbackFunctionsDetailsPage.this.event, "onTimeoutError", ""));
                        commands.addCommand(new Command(){

                            public void execute() {
                                LocalCallbackFunctionsDetailsPage.this.updateTimeOutText(true);
                            }
                        });
                        EventPropertiesMasterDetailsBlock.executeCommand(commands);
                    } else {
                        EventPropertiesMasterDetailsBlock.setEventProperty(LocalCallbackFunctionsDetailsPage.this.masterBlockTreeViewer, LocalCallbackFunctions.class, LocalCallbackFunctionsDetailsPage.this.event, "timeout", newText);
                        if (time == -1) {
                            LocalCallbackFunctionsDetailsPage.this.updateTimeOutText(false);
                        }
                    }
                }
            }
        });
        this.onTimeOutText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (LocalCallbackFunctionsDetailsPage.this.event.getOnTimeoutError() == null || !LocalCallbackFunctionsDetailsPage.this.event.getOnTimeoutError().equals(LocalCallbackFunctionsDetailsPage.this.onTimeOutText.getText())) {
                    EventPropertiesMasterDetailsBlock.setEventProperty(LocalCallbackFunctionsDetailsPage.this.masterBlockTreeViewer, LocalCallbackFunctions.class, LocalCallbackFunctionsDetailsPage.this.event, "onTimeoutError", LocalCallbackFunctionsDetailsPage.this.onTimeOutText.getText());
                }
            }
        });
        this.callbackFunctionsSection.setClient((Control)this.remoteComposite);
    }

    public void createLocalComposite() {
        this.localComposite = this.toolkit.createComposite((Composite)this.callbackFunctionsSection);
        this.localComposite.setLayout((Layout)new GridLayout(3, false));
        this.toolkit.createLabel(this.localComposite, Messages.getString("localCallbackDetails.beforeValidationLabel"));
        this.toolkit.createLabel(this.localComposite, ":");
        this.beforeValidationLocalText = this.toolkit.createText(this.localComposite, this.event.getStart(), 2052);
        this.beforeValidationLocalText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.toolkit.createLabel(this.localComposite, Messages.getString("localCallbackDetails.AfterDataStoreLabel"));
        this.toolkit.createLabel(this.localComposite, ":");
        this.afterStoredLocalText = this.toolkit.createText(this.localComposite, this.event.getFinish(), 2052);
        this.afterStoredLocalText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.beforeValidationLocalText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                LocalCallbackFunctionsDetailsPage.this.updateBeanBeforeValidation(LocalCallbackFunctionsDetailsPage.this.beforeValidationLocalText);
            }
        });
        this.afterStoredLocalText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                LocalCallbackFunctionsDetailsPage.this.updateBeanAfterStored(LocalCallbackFunctionsDetailsPage.this.afterStoredLocalText);
            }
        });
    }

    private void updateBeanBeforeValidation(Text textField) {
        if (this.event.getStart() == null || !this.event.getStart().equals(textField.getText())) {
            EventPropertiesMasterDetailsBlock.setEventProperty(this.masterBlockTreeViewer, LocalCallbackFunctions.class, this.event, "start", textField.getText());
        }
    }

    private void updateBeanAfterStored(Text textField) {
        if (this.event.getFinish() == null || !this.event.getFinish().equals(textField.getText())) {
            EventPropertiesMasterDetailsBlock.setEventProperty(this.masterBlockTreeViewer, LocalCallbackFunctions.class, this.event, "finish", textField.getText());
        }
    }
}

