/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.export;

import java.util.ArrayList;
import java.util.regex.Pattern;
import jp.sf.maskat.ui.wizards.export.XMLSchemaSelectGroup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class XMLSchemaSelectionDialog
extends SelectionDialog {
    private IAdaptable root;
    private XMLSchemaSelectGroup selectionGroup;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;

    public XMLSchemaSelectionDialog(Shell parentShell, IAdaptable rootElement, String message) {
        super(parentShell);
        this.setTitle(IDEWorkbenchMessages.ResourceSelectionDialog_title);
        this.root = rootElement;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(IDEWorkbenchMessages.ResourceSelectionDialog_message);
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.resource_selection_dialog_context");
    }

    public void create() {
        super.create();
        this.selectionGroup.setSelectionControl((Control)this.getOkButton());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ArrayList<IAdaptable> input = new ArrayList<IAdaptable>();
        input.add(this.root);
        this.createMessageArea(composite);
        this.selectionGroup = new XMLSchemaSelectGroup(composite, input, this.getResourceProvider(14, null), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1, new ResourceFilter("[\\p{Graph}]*_e.xml$$")), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, 400, 300);
        return composite;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType, final ResourceFilter filter) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    int i = 0;
                    while (i < members.length) {
                        if ((members[i].getType() & resourceType) > 0 && (filter == null || filter.accept(members[i]))) {
                            results.add(members[i]);
                        }
                        ++i;
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList)o).toArray();
                }
                return new Object[0];
            }
        };
    }

    public IFile getSelectEventXMLFile() {
        return (IFile)this.selectionGroup.getSelectObject();
    }

    private class ResourceFilter {
        private Pattern namePattern;

        ResourceFilter(String filterString) {
            this.namePattern = Pattern.compile(filterString);
        }

        public boolean accept(IResource resource) {
            return this.namePattern.matcher(resource.getName()).matches();
        }
    }
}

